#ifndef GSA_LIB_SCANNER_BASE_PROPERTIES_H
#define GSA_LIB_SCANNER_BASE_PROPERTIES_H

#include <GoSensorAppLib/GsaDef.h>
#include <GoApi/Properties/Nodes.h>
#include <GoSensorAppLib/StudioProtocol/Properties/Common.h>

namespace GoSensorApp
{

namespace GoProp = Go::Properties;

struct LightSleep : public GoProp::Structure
{
    GoProp::Value<bool> enabled;
    GoProp::Value<k64u> idleTime;
    GoProp::Value<k64u> wakeupEncoderTravel;

    LightSleep()
    {
        Register("enabled", enabled);
        Register("idleTime", idleTime);
        Register("wakeupEncoderTravel", wakeupEncoderTravel);
    }
};

struct BurstScan : public GoProp::Structure
{
    GoProp::Value<bool> enabled;
    GoProp::Value<k32s> enabledUsed;

    GoProp::Value<k32s> count;
    GoProp::Value<bool> countUsed;
    GoProp::Value<k32s> countMax;

    BurstScan()
    {
        Register("enabled", enabled);
        enabled.RegisterSchema("used", enabledUsed);

        Register("count", count);
        count.RegisterSchema("used", countUsed);
        count.RegisterSchema("maximum", countMax);
    }
};

struct Trigger : public GoProp::Structure
{
    GoProp::Value<k32s> source;
    GoProp::Value<std::vector<k32s>> sourceOptions;

    GoProp::Value<bool> maxFrameRateEnabled = true;
    MinMaxValue<k64f> frameRate;

    MinMaxValue<k64f> encoderSpacing;

    GoProp::Value<k32s> encoderTriggerMode;
    GoProp::Value<std::vector<k32s>> encoderTriggerModeOptions;

    GoProp::Value<k32s> externalInputIndex;
    GoProp::Value<bool> externalInputIndexUsed;
    GoProp::Value<std::vector<k32s>> externalInputIndexOptions;

    GoProp::Value<k32s> schedulingUnits;
    GoProp::Value<bool> schedulingUnitsUsed;

    MinMaxValue<k64f> delay;

    GoProp::Value<bool> gateEnabled;
    GoProp::Value<bool> gateEnabledUsed;

    GoProp::Value<bool> reversalDistanceAutoEnabled;
    GoProp::Value<bool> reversalDistanceAutoEnabledUsed;

    GoProp::Value<k64f> reversalDistance;
    GoProp::Value<bool> reversalDistanceUsed;

    LightSleep lightSleep;
    BurstScan burstScan;

    Trigger()
    {
        Register("source", source);
        source.RegisterSchema("enum", sourceOptions);

        Register("maxFrameRateEnabled", maxFrameRateEnabled);
        Register("frameRate", frameRate);

        Register("encoderSpacing", encoderSpacing);

        Register("encoderTriggerMode", encoderTriggerMode);
        encoderTriggerMode.RegisterSchema("enum", encoderTriggerModeOptions);

        Register("externalInputIndex", externalInputIndex);
        externalInputIndex.RegisterSchema("used", externalInputIndexUsed);
        externalInputIndex.RegisterSchema("enum", externalInputIndexOptions);

        Register("schedulingUnits", schedulingUnits);
        schedulingUnits.RegisterSchema("used", schedulingUnitsUsed);

        Register("delay", delay);

        Register("gateEnabled", gateEnabled);
        gateEnabled.RegisterSchema("used", gateEnabledUsed);

        Register("reversalDistanceAutoEnabled", reversalDistanceAutoEnabled);
        reversalDistanceAutoEnabled.RegisterSchema("used", reversalDistanceAutoEnabledUsed);

        Register("reversalDistance", reversalDistance);
        reversalDistance.RegisterSchema("used", reversalDistanceUsed);

        Register("lightSleep", lightSleep);
        Register("burstScan", burstScan);
    }
};

struct GridSensor : public GoProp::Structure
{
    GoProp::Value<std::string> sensorRef;
    GoProp::Value<std::string> name;

    GoProp::Value<k32s> orientation;
    GoProp::Value<std::vector<k32s>> orientationOptions;

    GoProp::Value<k32s> row;
    GoProp::Value<k32s> column;
    GoProp::Value<k32s> multiplexBank;

    GridSensor()
    {
        Register("sensorRef", sensorRef);
        Register("name", name);

        Register("orientation", orientation);
        orientation.RegisterSchema("enum", orientationOptions);

        Register("row", row);
        Register("column", column);
        Register("multiplexBank", multiplexBank);
    }
};

struct Grid : public GoProp::Structure
{
    GoProp::Value<k32s> columnCount;
    GoProp::Array<GridSensor> sensors;

    Grid()
    {
        Register("columnCount", columnCount);
        Register("sensors", sensors);
    }
};

struct Layout : public GoProp::Structure
{
    GoProp::Value<k32s> type = 0;
    GoProp::Value<std::vector<k32s>> typeOptions;

    Grid grid;

    Layout()
    {
        Register("layoutType", type);
        type.RegisterSchema("enum", typeOptions);

        Register("grid", grid);
    }
};

struct Multiplexing : public GoProp::Structure
{
    GoProp::Value<bool> enabled;
    GoProp::Value<bool> globalEnabled;
    GoProp::Value<k64u> globalDelay;
    GoProp::Value<k64u> globalPeriod;

    Multiplexing()
    {
        Register("enabled", enabled);
        Register("globalEnabled", globalEnabled);
        Register("globalDelay", globalDelay);
        Register("globalPeriod", globalPeriod);
    }
};

struct ScannerBase : public GoProp::Structure
{
    GoProp::Value<std::string> _deviceType;
    GoProp::Value<std::vector<std::string>> _deviceTypeOptions;
    GoProp::Value<k32s> _runningState = 0;
    GoProp::Value<std::vector<k32s>> _runningStateOptions;
    GoProp::Value<std::string> displayName;
    GoProp::Value<k32s> scanMode;
    GoProp::Value<std::vector<k32s>> scanModeOptions;

    GoProp::Value<bool> intensityEnabled = false;
    GoProp::Value<bool> intensityEnabledUsed = true;
    GoProp::Value<bool> uniformSpacingEnabled = true;
    GoProp::Value<bool> uniformSpacingEnabledUsed = true;
    GoProp::Value<bool> tempSafetyEnabled = false;
    GoProp::Value<bool> tempSafetyEnabledUsed = true;

    GoProp::Value<bool> externalInputZPulseEnabled = false;
    GoProp::Value<k32s> externalInputZPulseIndex;
    GoProp::Value<bool> externalInputZPulseIndexUsed = true;

    GoProp::Value<bool> preferMasterTimeEncoderEnabled = false;

    GoProp::Value<k32s> spacingIntervalMode;
    GoProp::Value<bool> spacingIntervalModeUsed;
    GoProp::Value<std::vector<k32s>> spacingIntervalModeOptions;

    MinMaxValue<k64f> spacingInterval;
    GoProp::Value<k64f> _spacingIntervalActual;

    Trigger trigger;
    Layout layout;
    Multiplexing multiplexing;

    ScannerBase()
    {
        Register("_deviceType", _deviceType);
        _deviceTypeOptions.Set({ "g1", "g2", "g3", "g2xx" });
        _deviceType.RegisterSchema("options", _deviceTypeOptions);
        Register("_runningState", _runningState);
        _runningStateOptions.Set({ -1,0,1 });
        _runningState.RegisterSchema("enum", _runningStateOptions);

        Register("displayName", displayName);
        Register("scanMode", scanMode);
        scanModeOptions.Set({ 0,1,2,3 });
        scanMode.RegisterSchema("enum", scanModeOptions);

        Register("intensityEnabled", intensityEnabled);
        intensityEnabled.RegisterSchema("used", intensityEnabledUsed);
        Register("uniformSpacingEnabled", uniformSpacingEnabled);
        uniformSpacingEnabled.RegisterSchema("used", uniformSpacingEnabledUsed);
        Register("tempSafetyEnabled", tempSafetyEnabled);
        tempSafetyEnabled.RegisterSchema("used", tempSafetyEnabledUsed);

        Register("externalInputZPulseEnabled", externalInputZPulseEnabled);
        Register("externalInputZPulseIndex", externalInputZPulseIndex);
        externalInputZPulseIndex.RegisterSchema("used", externalInputZPulseIndexUsed);

        Register("preferMasterTimeEncoderEnabled", preferMasterTimeEncoderEnabled);

        Register("spacingIntervalMode", spacingIntervalMode);
        spacingIntervalModeOptions.Set({ 0,1 });
        spacingIntervalMode.RegisterSchema("enum", spacingIntervalModeOptions);
        spacingIntervalMode.RegisterSchema("used", spacingIntervalModeUsed);

        Register("spacingInterval", spacingInterval);
        Register("_spacingIntervalActual", _spacingIntervalActual);

        Register("trigger", trigger);
        Register("layout", layout);
        Register("multiplexing", multiplexing);
    }
};

}; // namespaces

#endif
