#ifndef GSA_LIB_PROPERTIES_COMMON_H
#define GSA_LIB_PROPERTIES_COMMON_H

#include <GoSensorAppLib/GsaDef.h>
#include <GoApi/Configuration/Nodes.h>
#include <GoApi/Properties/Nodes.h>

namespace GoSensorApp
{

namespace GoProp = Go::Properties;
namespace GoCfg = Go::Configuration;

// Convienience function to copy options from old config optionsAttribute
// Will deprecate once studio develops more and able to retrieve properties directly
template<typename T>
inline void CopyOptions(GoProp::Value<std::vector<T>>& dstOptions, GoCfg::OptionsAttribute<T>& srcOptions)
{
    std::vector<T> tempOptions;
    for (size_t i = 0; i < srcOptions.Count(); i++)
    {
        tempOptions.push_back(srcOptions.At(i));
    }
    dstOptions.Set(tempOptions);
}

template<typename T>
struct MinMaxValue : GoProp::Value<T>
{
    GoProp::Value<T> min;
    GoProp::Value<T> max;
    GoProp::Value<bool> used = true;

    MinMaxValue()
    {
        this->RegisterSchema("minimum", min);
        this->RegisterSchema("maximum", max);
        this->RegisterSchema("used", used);
    }

    /*MinMaxValue& operator= (const GsCfgValue& other)
    {
        min = (T)other.min;
        max = (T)other.max;
        return *this;
    }*/
};

}; // namespaces

#endif
