#ifndef GS_REMOTE_APP_H
#define GS_REMOTE_APP_H

#include <GoSensorAppLib/GsaDef.h>
#include <GoSensor/GsDef.h>
#include <kFireSync/Server/kSvDef.h>
#include <kFireSync/Client/kPipe.h>
#include <kFireSync/kFsLib.h>

typedef kObject GsRemoteApp;

kDeclareClassEx(Gsa, GsRemoteApp, kObject)

GsaCx(kStatus) GsRemoteApp_Construct(GsRemoteApp* app, kAlloc allocator);

GsaCx(kStatus) GsRemoteApp_SetIpAddress(GsRemoteApp app, kIpAddress address);
GsaCx(kIpAddress) GsRemoteApp_IpAddress(GsRemoteApp app);

GsaCx(kStatus) GsRemoteApp_SetControlPort(GsRemoteApp app, k32u port);
GsaCx(k32u) GsRemoteApp_ControlPort(GsRemoteApp app);

GsaCx(kStatus) GsRemoteApp_SetHealthPort(GsRemoteApp app, k32u port);
GsaCx(k32u) GsRemoteApp_HealthPort(GsRemoteApp app);

GsaCx(kStatus) GsRemoteApp_SetUpgradePort(GsRemoteApp app, k32u port);
GsaCx(k32u) GsRemoteApp_UpgradePort(GsRemoteApp app);

GsaCx(kStatus) GsRemoteApp_SetWebPort(GsRemoteApp app, k32u port);
GsaCx(k32u) GsRemoteApp_WebPort(GsRemoteApp app);

GsaCx(kStatus) GsRemoteApp_SetPrivateDataPort(GsRemoteApp app, k32u port);
GsaCx(k32u) GsRemoteApp_PrivateDataPort(GsRemoteApp app);

GsaCx(kStatus) GsRemoteApp_SetPublicDataPort(GsRemoteApp app, k32u port);
GsaCx(k32u) GsRemoteApp_PublicDataPort(GsRemoteApp app);

GsaCx(kStatus) GsRemoteApp_SuppressTimeout(GsRemoteApp app, kBool suppress);
GsaCx(kStatus) GsRemoteApp_ForceConnect(GsRemoteApp app, kBool force);

GsaCx(kStatus) GsRemoteApp_Start(GsRemoteApp app, k32u deviceId);
GsaCx(kStatus) GsRemoteApp_Stop(GsRemoteApp app);

GsaCx(kStatus) GsRemoteApp_SetAcceleratorUpdateHandler(GsRemoteApp app, kCallbackFx function, kPointer receiver);

GsaCx(GsBuddyableStatus) GsRemoteApp_GetLastState();

GsaCx(kStatus) GsRemoteApp_WaitForShutdown(GsRemoteApp app);
GsaCx(kStatus) GsRemoteApp_TriggerShutdown(GsRemoteApp app);

#endif
