#ifndef TEST_SURFACE_DYNAMIC_ALIGNMENT_TOOL_X_H
#define TEST_SURFACE_DYNAMIC_ALIGNMENT_TOOL_X_H

#include <kVision/S3d/kS3dUtilities.h>
#include <kVision/L3d/kL3dCommon.h>
#include <kVision/L3d/kL3dChartPlotter.h>
#include <kVision/L3d/kL3dLinePalette.h>
#include <kVision/L3d/kL3dUtilities.h>

#define TEST_SURFACE_DYNAMIC_ALIGNMENT_TOOL_NAME        "TestSurfaceDynamicAlignment"
#define TEST_SURFACE_DYNAMIC_ALIGNMENT_TOOL_LABEL "Test Surface Dynamic Alignment"

#define    NUM_OF_REGIONS               3

#define PARAM_REGION1_NAME              "Region1"
#define PARAM_REGION2_NAME              "Region2"
#define PARAM_REGION3_NAME              "Region3"
#define PARAM_REGION1_LABEL             PARAM_REGION1_NAME
#define PARAM_REGION2_LABEL             PARAM_REGION2_NAME
#define PARAM_REGION3_LABEL             PARAM_REGION3_NAME

#define MEAS_XANGLE_INDEX               0
#define MEAS_YANGLE_INDEX               1
#define MEAS_ZTRANS_INDEX               2
#define MEAS_XANGLE_NAME                "X_Angle"
#define MEAS_YANGLE_NAME                "Y_Angle"
#define MEAS_ZTRANS_NAME                "Z_Translation"
#define MEAS_XANGLE_LABEL               MEAS_XANGLE_NAME
#define MEAS_YANGLE_LABEL               MEAS_YANGLE_NAME
#define MEAS_ZTRANS_LABEL               MEAS_ZTRANS_NAME

#define OUTPUT_ALIGNED_SURFACE_NAME     "OutSurface"
#define OUTPUT_ALIGNED_SURFACE_LABEL    "Out Surface"
#define OUTPUT_ALIGNED_SURFACE_INDEX    3

#define PARAM_TRANS_X_NAME              "TranslateX"
#define PARAM_TRANS_X_LABEL             "Translate X"
#define PARAM_TRANS_Y_NAME              "TranslateY"
#define PARAM_TRANS_Y_LABEL             "Translate Y"
#define PARAM_TRANS_Z_NAME              "TranslateZ"
#define PARAM_TRANS_Z_LABEL             "Translate Z"
#define PARAM_ANGLE_X_NAME              "AngleX"
#define PARAM_ANGLE_X_LABEL             "Angle X"
#define PARAM_ANGLE_Y_NAME              "AngleY"
#define PARAM_ANGLE_Y_LABEL             "Angle Y"
#define PARAM_ANGLE_Z_NAME              "AngleZ"
#define PARAM_ANGLE_Z_LABEL             "Angle Z"
#define PARAM_DEGREES_NAME              "Degrees"
#define PARAM_DEGREES_LABEL             PARAM_DEGREES_NAME

typedef struct TestSurfaceDynamicAlignmentClass 
{
    GdkToolClass base;
    GdkDataSource dataSource;

    GdkRegion3d64f regions[NUM_OF_REGIONS];

} TestSurfaceDynamicAlignmentClass;

kDeclareClassEx(Tool, TestSurfaceDynamicAlignment, GdkTool)

ToolFx(const kChar*) TestSurfaceDynamicAlignment_VName();
ToolFx(kStatus) TestSurfaceDynamicAlignment_VDescribe(GdkToolInfo info);
ToolFx(kStatus) TestSurfaceDynamicAlignment_VStart(TestSurfaceDynamicAlignment tool);
ToolFx(kStatus) TestSurfaceDynamicAlignment_VStop(TestSurfaceDynamicAlignment tool);
ToolFx(kStatus) TestSurfaceDynamicAlignment_VProcess(TestSurfaceDynamicAlignment tool, GdkToolInput input, GdkToolOutput output);
ToolFx(kStatus) TestSurfaceDynamicAlignment_VInit(TestSurfaceDynamicAlignment tool, kType type, kAlloc alloc);
ToolFx(kStatus) TestSurfaceDynamicAlignment_VRelease(TestSurfaceDynamicAlignment tool);
ToolFx(kStatus) TestSurfaceDynamicAlignment_VNewToolConfig(const GdkToolEnv* env, GdkToolCfg toolConfig);
ToolFx(kStatus) TestSurfaceDynamicAlignment_VNewMeasurementConfig(const GdkToolEnv* env, GdkToolCfg toolConfig, GdkMeasurementCfg measurementConfig);
ToolFx(kStatus) TestSurfaceDynamicAlignment_VUpdateConfig(const GdkToolEnv* env, GdkToolCfg toolConfig);

ToolFx(kStatus) TestSurfaceDynamicAlignment_OutputValue(GdkToolOutput output, kSize index, k64f value, kBool valid, GdkToolCfg config);

ToolFx(kStatus) GetAvgPoints(TestSurfaceDynamicAlignment tool, GdkToolInput item, kPoint3d64f* regionAvg);
ToolFx(kStatus) FitPlane(kPoint3d64f* points, k64f* xAngle, k64f* yAngle, k64f* zIntersect);
ToolFx(kStatus) TransformSurface(GdkToolInput item, k64f xAngle, k64f yAngle, k64f zIntersect, kArray2* outPointArray, kPoint3d64f* offset, kAlloc alloc);

ToolFx(kPoint3d64f) Vector_Subtract(kPoint3d64f a, kPoint3d64f b);
ToolFx(kPoint3d64f) Vector_CrossProduct(kPoint3d64f a, kPoint3d64f b);

#endif



