
export K_REGENERATOR := 1
export K_X64_LINUX_CUDA_VERSION := 0
export K_X64_LINUX_DEBUG_INFO := 1

ifeq ($(OS)$(os), Windows_NT)
	CROSS_PREFIX := C:/tools/GccX64_4.9.4-p23/x86_64-linux-gnu/bin/x86_64-linux-gnu-
	CROSS_SUFFIX := .exe
	PYTHON := python
	MKDIR_P := $(PYTHON) ../../Platform/scripts/Utils/kUtil.py mkdir_p
	RM_F := $(PYTHON) ../../Platform/scripts/Utils/kUtil.py rm_f
	RM_RF := $(PYTHON) ../../Platform/scripts/Utils/kUtil.py rm_rf
	CP := $(PYTHON) ../../Platform/scripts/Utils/kUtil.py cp
	KGENERATOR := $(PYTHON) ../../Platform/scripts/Utils/kGenerator.py
else
	BUILD_MACHINE := $(shell uname -m)
	ifneq ($(BUILD_MACHINE), x86_64)
		CROSS_PREFIX := /tools/GccX64_4.9.4-p23/x86_64-linux-gnu/bin/x86_64-linux-gnu-
		CROSS_SUFFIX := 
	endif
	PYTHON := python3
	MKDIR_P := mkdir -p
	RM_F := rm -f
	RM_RF := rm -rf
	CP := cp
	KGENERATOR := $(PYTHON) ../../Platform/scripts/Utils/kGenerator.py
endif

C_COMPILER := $(CROSS_PREFIX)gcc$(CROSS_SUFFIX)
CXX_COMPILER := $(CROSS_PREFIX)g++$(CROSS_SUFFIX)
LINKER := $(CROSS_PREFIX)g++$(CROSS_SUFFIX)
ARCHIVER := $(CROSS_PREFIX)ar$(CROSS_SUFFIX)
GNU_READELF := $(CROSS_PREFIX)readelf$(CROSS_SUFFIX)
APP_GEN := $(PYTHON) ../../Platform/scripts/Utils/kAppGen.py

ifndef verbose
	SILENT := @
endif

ifndef config
	config := Debug
endif

# We require tools to be installed according to specific conventions (see manuals).
# Tool prerequisites may change between major releases; check and report.
ifeq ($(shell $(C_COMPILER) --version),)
.PHONY: tc_err
tc_err:
	$(error Cannot build because of missing prerequisite; please install)
endif

ifeq ($(config),Debug)
	TARGET := ../../lib/linux_x64d/GdkAppSample.so
	INTERMEDIATES := 
	OBJ_DIR := ../../build/GdkAppSample-gnumk_linux_x64-Debug
	PREBUILD := 
	POSTBUILD := 
	COMPILER_FLAGS := -g -march=x86-64 -fpic
	C_FLAGS := -std=gnu99 -Wall -Wno-unused-variable -Wno-unused-parameter -Wno-unused-value -Wno-missing-braces
	CXX_FLAGS := -std=c++14 -Wall -Wfloat-conversion
	INCLUDE_DIRS := -I. -I../../Platform/kApi -I../../Platform/kFireSync -I../../Platform/kHardware -I../../Platform/kVision -I../Gdk -I../GoVision -I../GoSensor -I../GoSensorApp
	DEFINES := -DK_DEBUG -DK_PLUGIN -DGO_GDK_DYNAMIC -DGDKAPP
	LINKER_FLAGS := -shared -Wl,-no-undefined -Wl,-rpath,'$$ORIGIN'
	LIB_DIRS := -L../../lib/linux_x64d
	LIBS := -Wl,--start-group -lkApi -lkFireSync -lkVision -lGdk -lGoVision -lGoTools -lGoSensor -lGoApi -lGoSensorAppLib -Wl,--end-group
	LDFLAGS := $(LINKER_FLAGS) $(LIBS) $(LIB_DIRS)

	OBJECTS := ../../build/GdkAppSample-gnumk_linux_x64-Debug/Asm.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestProfileSelect.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestMesh.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceSelect.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceConfiguration.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceGraphics.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceFeatures.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestFeatureAverage.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceDynamicAlignment.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestProfileDynamicAlignment.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestDynamicOutputs.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestGenericInput.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/GdkPartSegmentResult.cpp.o
	DEP_FILES = ../../build/GdkAppSample-gnumk_linux_x64-Debug/Asm.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestProfileSelect.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestMesh.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceSelect.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceConfiguration.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceGraphics.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceFeatures.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestFeatureAverage.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceDynamicAlignment.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestProfileDynamicAlignment.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestDynamicOutputs.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/TestGenericInput.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Debug/GdkPartSegmentResult.cpp.d
	TARGET_DEPS = 

endif

ifeq ($(config),Release)
	TARGET := ../../lib/linux_x64/GdkAppSample.so
	INTERMEDIATES := 
	OBJ_DIR := ../../build/GdkAppSample-gnumk_linux_x64-Release
	PREBUILD := 
	POSTBUILD := 
	COMPILER_FLAGS := -O2 -march=x86-64 -fpic
	C_FLAGS := -std=gnu99 -Wall -Wno-unused-variable -Wno-unused-parameter -Wno-unused-value -Wno-missing-braces
	CXX_FLAGS := -std=c++14 -Wall -Wfloat-conversion
	INCLUDE_DIRS := -I. -I../../Platform/kApi -I../../Platform/kFireSync -I../../Platform/kHardware -I../../Platform/kVision -I../Gdk -I../GoVision -I../GoSensor -I../GoSensorApp
	DEFINES := -DK_PLUGIN -DGO_GDK_DYNAMIC -DGDKAPP
	LINKER_FLAGS := -shared -Wl,-no-undefined -Wl,-rpath,'$$ORIGIN'
	LIB_DIRS := -L../../lib/linux_x64
	LIBS := -Wl,--start-group -lkApi -lkFireSync -lkVision -lGdk -lGoVision -lGoTools -lGoSensor -lGoApi -lGoSensorAppLib -Wl,--end-group
	LDFLAGS := $(LINKER_FLAGS) $(LIBS) $(LIB_DIRS)

	OBJECTS := ../../build/GdkAppSample-gnumk_linux_x64-Release/Asm.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestProfileSelect.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestMesh.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceSelect.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceConfiguration.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceGraphics.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceFeatures.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestFeatureAverage.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceDynamicAlignment.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestProfileDynamicAlignment.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestDynamicOutputs.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestGenericInput.cpp.o \
	../../build/GdkAppSample-gnumk_linux_x64-Release/GdkPartSegmentResult.cpp.o
	DEP_FILES = ../../build/GdkAppSample-gnumk_linux_x64-Release/Asm.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestProfileSelect.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestMesh.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceSelect.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceConfiguration.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceGraphics.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceFeatures.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestFeatureAverage.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceDynamicAlignment.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestProfileDynamicAlignment.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestDynamicOutputs.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Release/TestGenericInput.cpp.d \
	../../build/GdkAppSample-gnumk_linux_x64-Release/GdkPartSegmentResult.cpp.d
	TARGET_DEPS = 

endif

ifdef profile
	COMPILER_FLAGS += -pg
	LDFLAGS += -pg
endif

ifdef coverage
	COMPILER_FLAGS += --coverage -fprofile-arcs -ftest-coverage
	LDFLAGS += --coverage
	LIBS += -lgcov
endif

ifdef sanitize
	COMPILER_FLAGS += -fsanitize=$(sanitize)
	LDFLAGS += -fsanitize=$(sanitize)
endif

.PHONY: all all-obj all-dep clean

all: $(OBJ_DIR)
	$(PREBUILD)
	$(SILENT) $(MAKE) -f GdkAppSample-Linux_X64.mk all-dep
	$(SILENT) $(MAKE) -f GdkAppSample-Linux_X64.mk all-obj

clean:
	$(SILENT) $(info Cleaning $(OBJ_DIR))
	$(SILENT) $(RM_RF) $(OBJ_DIR)
	$(SILENT) $(info Cleaning $(TARGET) $(INTERMEDIATES))
	$(SILENT) $(RM_F) $(TARGET) $(INTERMEDIATES)

all-obj: $(OBJ_DIR) $(TARGET)
all-dep: $(OBJ_DIR) $(DEP_FILES)

$(OBJ_DIR): GdkAppSample-Linux_X64.mk
	$(info Cleanse $(OBJ_DIR))
	$(SILENT) $(RM_RF) $(OBJ_DIR)
	$(SILENT) $(MKDIR_P) $(OBJ_DIR)

ifeq ($(MAKECMDGOALS),)
ifeq ($(MAKE_RESTARTS),)
GdkAppSample-Linux_X64.mk: GdkAppSample.xml ../Gdk.xml ../../Platform/scripts/Utils/Generator/GnuMk.py
	$(info RegenX64 GdkAppSample-Linux_X64.mk)
	$(SILENT) $(KGENERATOR) --writers=GnuMk_Linux_X64 --platforms=Linux_X64 --project=GdkAppSample ../Gdk.xml
endif
endif

ifeq ($(config),Debug)

$(TARGET): $(OBJECTS) $(TARGET_DEPS)
	$(SILENT) $(info LdX64 $(TARGET))
	$(SILENT) $(LINKER) $(OBJECTS) $(LDFLAGS) -o$(TARGET)

endif

ifeq ($(config),Release)

$(TARGET): $(OBJECTS) $(TARGET_DEPS)
	$(SILENT) $(info LdX64 $(TARGET))
	$(SILENT) $(LINKER) $(OBJECTS) $(LDFLAGS) -o$(TARGET)

endif

ifeq ($(config),Debug)

../../build/GdkAppSample-gnumk_linux_x64-Debug/Asm.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Debug/Asm.cpp.d: GdkAppSample/Asm.cpp
	$(SILENT) $(info GccX64 GdkAppSample/Asm.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Debug/Asm.cpp.o -c GdkAppSample/Asm.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Debug/TestProfileSelect.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestProfileSelect.cpp.d: GdkAppSample/TestProfileSelect.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestProfileSelect.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestProfileSelect.cpp.o -c GdkAppSample/TestProfileSelect.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Debug/TestMesh.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestMesh.cpp.d: GdkAppSample/TestMesh.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestMesh.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestMesh.cpp.o -c GdkAppSample/TestMesh.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceSelect.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceSelect.cpp.d: GdkAppSample/TestSurfaceSelect.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestSurfaceSelect.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceSelect.cpp.o -c GdkAppSample/TestSurfaceSelect.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceConfiguration.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceConfiguration.cpp.d: GdkAppSample/TestSurfaceConfiguration.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestSurfaceConfiguration.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceConfiguration.cpp.o -c GdkAppSample/TestSurfaceConfiguration.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceGraphics.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceGraphics.cpp.d: GdkAppSample/TestSurfaceGraphics.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestSurfaceGraphics.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceGraphics.cpp.o -c GdkAppSample/TestSurfaceGraphics.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceFeatures.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceFeatures.cpp.d: GdkAppSample/TestSurfaceFeatures.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestSurfaceFeatures.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceFeatures.cpp.o -c GdkAppSample/TestSurfaceFeatures.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Debug/TestFeatureAverage.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestFeatureAverage.cpp.d: GdkAppSample/TestFeatureAverage.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestFeatureAverage.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestFeatureAverage.cpp.o -c GdkAppSample/TestFeatureAverage.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceDynamicAlignment.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceDynamicAlignment.cpp.d: GdkAppSample/TestSurfaceDynamicAlignment.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestSurfaceDynamicAlignment.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceDynamicAlignment.cpp.o -c GdkAppSample/TestSurfaceDynamicAlignment.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Debug/TestProfileDynamicAlignment.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestProfileDynamicAlignment.cpp.d: GdkAppSample/TestProfileDynamicAlignment.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestProfileDynamicAlignment.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestProfileDynamicAlignment.cpp.o -c GdkAppSample/TestProfileDynamicAlignment.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Debug/TestDynamicOutputs.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestDynamicOutputs.cpp.d: GdkAppSample/TestDynamicOutputs.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestDynamicOutputs.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestDynamicOutputs.cpp.o -c GdkAppSample/TestDynamicOutputs.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Debug/TestGenericInput.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestGenericInput.cpp.d: GdkAppSample/TestGenericInput.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestGenericInput.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestGenericInput.cpp.o -c GdkAppSample/TestGenericInput.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Debug/GdkPartSegmentResult.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Debug/GdkPartSegmentResult.cpp.d: GdkAppSample/GdkPartSegmentResult.cpp
	$(SILENT) $(info GccX64 GdkAppSample/GdkPartSegmentResult.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Debug/GdkPartSegmentResult.cpp.o -c GdkAppSample/GdkPartSegmentResult.cpp -MMD -MP

endif

ifeq ($(config),Release)

../../build/GdkAppSample-gnumk_linux_x64-Release/Asm.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Release/Asm.cpp.d: GdkAppSample/Asm.cpp
	$(SILENT) $(info GccX64 GdkAppSample/Asm.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Release/Asm.cpp.o -c GdkAppSample/Asm.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Release/TestProfileSelect.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestProfileSelect.cpp.d: GdkAppSample/TestProfileSelect.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestProfileSelect.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestProfileSelect.cpp.o -c GdkAppSample/TestProfileSelect.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Release/TestMesh.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestMesh.cpp.d: GdkAppSample/TestMesh.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestMesh.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestMesh.cpp.o -c GdkAppSample/TestMesh.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceSelect.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceSelect.cpp.d: GdkAppSample/TestSurfaceSelect.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestSurfaceSelect.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceSelect.cpp.o -c GdkAppSample/TestSurfaceSelect.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceConfiguration.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceConfiguration.cpp.d: GdkAppSample/TestSurfaceConfiguration.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestSurfaceConfiguration.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceConfiguration.cpp.o -c GdkAppSample/TestSurfaceConfiguration.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceGraphics.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceGraphics.cpp.d: GdkAppSample/TestSurfaceGraphics.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestSurfaceGraphics.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceGraphics.cpp.o -c GdkAppSample/TestSurfaceGraphics.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceFeatures.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceFeatures.cpp.d: GdkAppSample/TestSurfaceFeatures.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestSurfaceFeatures.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceFeatures.cpp.o -c GdkAppSample/TestSurfaceFeatures.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Release/TestFeatureAverage.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestFeatureAverage.cpp.d: GdkAppSample/TestFeatureAverage.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestFeatureAverage.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestFeatureAverage.cpp.o -c GdkAppSample/TestFeatureAverage.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceDynamicAlignment.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceDynamicAlignment.cpp.d: GdkAppSample/TestSurfaceDynamicAlignment.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestSurfaceDynamicAlignment.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceDynamicAlignment.cpp.o -c GdkAppSample/TestSurfaceDynamicAlignment.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Release/TestProfileDynamicAlignment.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestProfileDynamicAlignment.cpp.d: GdkAppSample/TestProfileDynamicAlignment.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestProfileDynamicAlignment.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestProfileDynamicAlignment.cpp.o -c GdkAppSample/TestProfileDynamicAlignment.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Release/TestDynamicOutputs.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestDynamicOutputs.cpp.d: GdkAppSample/TestDynamicOutputs.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestDynamicOutputs.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestDynamicOutputs.cpp.o -c GdkAppSample/TestDynamicOutputs.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Release/TestGenericInput.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestGenericInput.cpp.d: GdkAppSample/TestGenericInput.cpp
	$(SILENT) $(info GccX64 GdkAppSample/TestGenericInput.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Release/TestGenericInput.cpp.o -c GdkAppSample/TestGenericInput.cpp -MMD -MP

../../build/GdkAppSample-gnumk_linux_x64-Release/GdkPartSegmentResult.cpp.o ../../build/GdkAppSample-gnumk_linux_x64-Release/GdkPartSegmentResult.cpp.d: GdkAppSample/GdkPartSegmentResult.cpp
	$(SILENT) $(info GccX64 GdkAppSample/GdkPartSegmentResult.cpp)
	$(SILENT) $(CXX_COMPILER) $(COMPILER_FLAGS) $(CXX_FLAGS) $(DEFINES) $(INCLUDE_DIRS) -o ../../build/GdkAppSample-gnumk_linux_x64-Release/GdkPartSegmentResult.cpp.o -c GdkAppSample/GdkPartSegmentResult.cpp -MMD -MP

endif

ifeq ($(MAKECMDGOALS),all-obj)

ifeq ($(config),Debug)

include ../../build/GdkAppSample-gnumk_linux_x64-Debug/Asm.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestProfileSelect.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestMesh.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceSelect.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceConfiguration.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceGraphics.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceFeatures.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestFeatureAverage.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestSurfaceDynamicAlignment.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestProfileDynamicAlignment.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestDynamicOutputs.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Debug/TestGenericInput.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Debug/GdkPartSegmentResult.cpp.d

endif

ifeq ($(config),Release)

include ../../build/GdkAppSample-gnumk_linux_x64-Release/Asm.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Release/TestProfileSelect.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Release/TestMesh.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceSelect.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceConfiguration.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceGraphics.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceFeatures.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Release/TestFeatureAverage.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Release/TestSurfaceDynamicAlignment.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Release/TestProfileDynamicAlignment.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Release/TestDynamicOutputs.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Release/TestGenericInput.cpp.d
include ../../build/GdkAppSample-gnumk_linux_x64-Release/GdkPartSegmentResult.cpp.d

endif

endif

