/**
* @file    GdkRuntimeVars.h
* @brief   Declares the GdkRuntimeVars interfaces.
*
* Copyright (C) 2017-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_RUNTIME_VARS_H
#define GDK_RUNTIME_VARS_H

#include <Gdk/GdkDef.h>

/**
* Describes the interfaces to read and write runtime variables from a Gdk tool.
*
* @class       GdkRuntimeVars
* @ingroup     Gdk-Utils
*/

/**
 * Read the 32-bit signed integer runtime variables from the sensor.
 *
 * @public               @memberof GdkRuntimeVars
 * @param   dataOut      kArray1 of k32s to hold the runtime variable
 *                       data read from sensor.
 * @return               Operation status.
 */
GdkFx(kStatus) GdkRuntimeVars_Read32s(kArray1 dataOut);

/**
 * Write 32-bit signed integer runtime variables into the sensor.
 *
 * @public               @memberof GdkRuntimeVars
 * @param   dataIn       kArray1 of k32s which holds the runtime variable
 *                       data to be written into the sensor.
 * @return               Operation status.
 */
GdkFx(kStatus) GdkRuntimeVars_Write32s(kArray1 dataIn);

#endif // GDK_RUNTIME_VARS_H
