/**
* @file    GdkGraphicPlane.h
* @brief   Declares the GdkGraphicPlane class.
*
* @internal
* Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_GRAPHIC_RAY_H
#define GDK_GRAPHIC_RAY_H

#include <Gdk/GdkDef.h>
#include <kFireSync/Data/kGraphic.h>

/**
* @class       GdkGraphicRay
* @extends     kObject
* @ingroup     Gdk-Data
* @brief       Represents a plane.
*/
typedef kObject GdkGraphicRay;

/**
* Constructs a plane object.
*
* @public                  @memberof GdkGraphicRay
* @param   ray             Destination for the constructed object handle.
* @param   allocator       Memory allocator (or kNULL for default).
* @return                  Operation status.
*/
GdkFx(kStatus) GdkGraphicRay_Construct(GdkGraphicRay* ray, kObject allocator);

/**
* Sets the normal of a ray
*
* @public                   @memberof GdkGraphicRay
* @param   ray              GdkGraphicPlane object.
* @param   normal           normal point3D
* @return                   Operation status.
*/
GdkFx(kStatus)GdkGraphicRay_SetNormal(GdkGraphicRay ray, kPoint3d32f normal);

/**
* Sets the position of a ray
*
* @public                   @memberof GdkGraphicRay
* @param   ray              GdkGraphicPlane object.
* @param   position         3d position
* @return                   Operation status.
*/
GdkFx(kStatus) GdkGraphicRay_SetPosition(GdkGraphicRay ray, kPoint3d32f  position);

/**
* Sets the width of a ray
*
* @public                   @memberof GdkGraphicRay
* @param   ray              GdkGraphicPlane object.
* @param   width            width of ray
* @return                   Operation status.
*/
GdkFx(kStatus) GdkGraphicRay_SetWidth(GdkGraphicRay ray, k32f  width);

/**
* Sets the colour of a ray
*
* @public                   @memberof GdkGraphicRay
* @param   ray              GdkGraphicPlane object.
* @param   colour           colour of ray
* @return                   Operation status.
*/
GdkFx(kStatus) GdkGraphicRay_SetColor(GdkGraphicRay ray, kColor  colour);

#include <Gdk/Data/GdkGraphicRay.x.h>

#endif
