/**
* @file     GdkGraphicPosition.x.h
*
* @internal
* Copyright (C) 2018-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_GRAPHIC_POSITION_X_H
#define GDK_GRAPHIC_POSITION_X_H

#include <kApi/Data/kMath.h>
#include <kApi/Data/kString.h>

#include <Gdk/GdkDef.h>

typedef struct GdkGraphicPositionClass
{
    kObjectClass base;
    GdkGraphicPositionType type;
    kPoint3d64f position;
} GdkGraphicPositionClass;

kDeclareClassEx(Gdk, GdkGraphicPosition,kObject)

#define GdkGraphicPositionTypeCheck(OBJTYPE)     {if (!kObject_Is(OBJTYPE, kTypeOf(GdkGraphicPosition))) return kERROR_UNIMPLEMENTED;}

GdkFx(kStatus) GdkGraphicPosition_Init(GdkGraphicPosition graphic, kType classType, kAlloc allocator);
GdkFx(kStatus) GdkGraphicPosition_Release(GdkGraphicPosition graphic);

GdkFx(kStatus) GdkGraphicPosition_VRelease(GdkGraphicPosition graphic);
GdkFx(kStatus) GdkGraphicPosition_Serialize(GdkGraphicPosition graphic, kSerializer serializer);

#endif
