/**
* @file    GdkGraphicPosition.h
* @brief   Declares the GdkGraphicPosition class.
*
* @internal
* Copyright (C) 2018-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_GRAPHIC_POSITION_H
#define GDK_GRAPHIC_POSITION_H

#include <Gdk/GdkDef.h>

/**
* @class       GdkGraphicPosition
* @extends     kObject
* @ingroup     Gdk-Data
* @brief       Represents a label.
*/
typedef kObject GdkGraphicPosition;

/**
* Constructs a position object.
*
* @public                  @memberof GdkGraphicPosition
* @param   object          Destination for the constructed object handle.
* @param   allocator       Memory allocator (or kNULL for default).
* @return                  Operation status.
*/
GdkFx(kStatus) GdkGraphicPosition_Construct(GdkGraphicPosition* object, kObject allocator);

/**
* Sets the type of a position
*
* @public                   @memberof GdkGraphicPosition
* @param   object           GdkGraphicPosition object.
* @param   type             Position type: 
* @return                   Operation status.
*/
GdkFx(kStatus)GdkGraphicPosition_SetType(GdkGraphicPosition object, GdkGraphicPositionType type);

/**
* Sets the to the position of the label
*
* @public                   @memberof GdkGraphicPosition
* @param   object           GdkGraphicPosition object.
* @param   position         Pointer to position of label in space coordinates
* @return                   Operation status.
*/
GdkFx(kStatus) GdkGraphicPosition_SetPosition(GdkGraphicPosition object, const kPoint3d64f *position);

#include <Gdk/Data/GdkGraphicPosition.x.h>

#endif
