/**
* @file    GdkGraphicPlane.h
* @brief   Declares the GdkGraphicPlane class.
*
* @internal
* Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_GRAPHIC_PLANE_H
#define GDK_GRAPHIC_PLANE_H

#include <Gdk/GdkDef.h>

/**
* @class       GdkGraphicPlane
* @extends     kObject
* @ingroup     Gdk-Data
* @brief       Represents a plane.
*/
typedef kObject GdkGraphicPlane;

/**
* Constructs a plane object.
*
* @public                  @memberof GdkGraphicPlane
* @param   plane           Destination for the constructed object handle.
* @param   allocator       Memory allocator (or kNULL for default).
* @return                  Operation status.
*/
GdkFx(kStatus) GdkGraphicPlane_Construct(GdkGraphicPlane* plane, kObject allocator);

/**
* Sets the normal of a plane
*
* @public                   @memberof GdkGraphicPlane
* @param   plane            GdkGraphicPlane object.
* @param   normal           normal point3D
* @return                   Operation status.
*/
GdkFx(kStatus)GdkGraphicPlane_SetNormal(GdkGraphicPlane plane, kPoint3d32f normal);

/**
* Sets the to the origin of a plane
*
* @public                   @memberof GdkGraphicPlane
* @param   plane            GdkGraphicPlane object.
* @param   distance         distance to origin
* @return                   Operation status.
*/
GdkFx(kStatus) GdkGraphicPlane_SetDistance(GdkGraphicPlane plane, k32f distance);

#include <Gdk/Data/GdkGraphicPlane.x.h>

#endif
