/** 
 * @file    GdkGraphic.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef GDK_GRAPHIC_X_H
#define GDK_GRAPHIC_X_H

#include <kFireSync/Data/kGraphic.h>
#include <kApi/Data/kMath.h>
#include <kApi/Data/kArrayList.h>

kDeclareClassEx(Gdk, GdkGraphicLineSet, kObject)
typedef struct GdkGraphicLineSetClass
{
    kObjectClass base;
    k32f width;
    kColor colour;
    kArrayList set; //of kPoint3d32f
}GdkGraphicLineSetClass;

#define GdkGraphicLineSetTypeCheck(OBJTYPE)     {if (!kObject_Is(OBJTYPE, kTypeOf(GdkGraphicLineSet))) return kERROR_UNIMPLEMENTED;}

GdkFx(kStatus) GdkGraphicLineSet_Init(GdkGraphicLineSet set, kType classType, 
                                    k32f width, kColor colour, 
                                    const kPoint3d32f* points, kSize count,
                                    kAlloc allocator);
GdkFx(kStatus) GdkGraphicLineSet_VInitClone(GdkGraphicLineSet dest, 
                                          GdkGraphicLineSet source, 
                                          kAlloc allocator);
GdkFx(kStatus) GdkGraphicLineSet_VRelease(GdkGraphicLineSet set);
GdkFx(kSize) GdkGraphicLineSet_VSize(GdkGraphicLineSet set);

kDeclareClassEx(Gdk, GdkGraphicPointSet, kObject)
typedef struct GdkGraphicPointSetClass
{
    kObjectClass base;
    k32f size;
    kMarkerShape shape;
    kColor colour;
    kArrayList set; //of type kPoint3d32f
}GdkGraphicPointSetClass;

#define GdkGraphicPointSetTypeCheck(OBJTYPE)     {if (!kObject_Is(OBJTYPE, kTypeOf(GdkGraphicPointSet))) return kERROR_UNIMPLEMENTED;}

GdkFx(kStatus) GdkGraphicPointSet_Init(GdkGraphicPointSet set, 
                                     kType classType,
                                     k32f size, kMarkerShape shape, 
                                     kColor colour, 
                                     const kPoint3d32f* points, 
                                     kSize count, kAlloc allocator);
GdkFx(kStatus) GdkGraphicPointSet_VInitClone(GdkGraphicPointSet dest, 
                                           GdkGraphicPointSet source, 
                                           kAlloc allocator);
GdkFx(kStatus) GdkGraphicPointSet_VRelease(GdkGraphicPointSet set);
GdkFx(kSize) GdkGraphicPointSet_VSize(GdkGraphicPointSet set);

kDeclareClassEx(Gdk, GdkGraphic, kObject)

typedef struct GdkGraphicClass
{
    kObjectClass base; 
    GdkDataType srcDataType;
    kArrayList lineSetList;   //GdkGraphicLineSet
    kArrayList pointSetList;  //GdkGraphicPointSet
    kArrayList anchorRegions; //GdkGraphicAnchorRegion
    kArrayList planeList; //GdkGraphicPlanes
    kArrayList rayList; //GdkGraphicRays
    kArrayList labelList; //GdkGraphicLabels
    kArrayList positionList; //GdkGraphicPositions
} GdkGraphicClass; 

#define GdkGraphicTypeCheck(OBJTYPE)     {if (!kObject_Is(OBJTYPE, kTypeOf(GdkGraphic))) return kERROR_UNIMPLEMENTED;}

GdkFx(kStatus) GdkGraphic_Init(GdkGraphic graphic, kType classType, kAlloc allocator);
GdkFx(kStatus) GdkGraphic_VInitClone(GdkGraphic graphic, GdkGraphic source, kAlloc allocator); 
GdkFx(kStatus) GdkGraphic_Release(GdkGraphic graphic); 

GdkFx(kStatus) GdkGraphic_VRelease(GdkGraphic graphic);
GdkFx(kSize) GdkGraphic_VSize(GdkGraphic graphic);


GdkFx(GdkDataType) GdkGraphic_SourceDataType(GdkGraphic graphic);
GdkFx(kStatus) GdkGraphic_SetSourceDataType(GdkGraphic graphic, GdkDataType srcDataType);

GdkFx(kArrayList) GdkGraphic_AnchorRegionList(GdkGraphic graphic);
GdkFx(kArrayList) GdkGraphicLineSet_PointList(GdkGraphicLineSet set);
GdkFx(kArrayList) GdkGraphicPointSet_PointList(GdkGraphicPointSet set);
GdkFx(kArrayList) GdkGraphic_LineSetList(GdkGraphic graphic);
GdkFx(kArrayList) GdkGraphic_PointSetList(GdkGraphic graphic);
GdkFx(kArrayList) GdkGraphic_PlaneList(GdkGraphic graphic);
GdkFx(kArrayList) GdkGraphic_RayList(GdkGraphic graphic);
GdkFx(kArrayList) GdkGraphic_LabelList(GdkGraphic graphic);
GdkFx(kArrayList) GdkGraphic_PositionList(GdkGraphic graphic);

#endif
