/**
* @file    GdkToolDataOutputCfg.h
* @brief   Declares the GdkToolDataOutputCfg class.
*
* Copyright (C) 2017-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_TOOLDATA_OUTPUT_CFG_H
#define GDK_TOOLDATA_OUTPUT_CFG_H

#include <Gdk/GdkDef.h>
#include <Gdk/Config/GdkToolOutputCfg.h>
#include <Gdk/Config/GdkParams.h>

/**
* Represents configuration for a tool data output.
*
* @class       GdkToolDataOutputCfg
* @ingroup     Gdk-Config
*/
typedef kPointer GdkToolDataOutputCfg;

/**
* Returns the tool data output Data type.
*
* @public               @memberof GdkToolDataOutputCfg
* @param    config      Configuration object.
* @return               Data type of the tool data output.
*/
GdkFx(GdkDataType) GdkToolDataOutputCfg_DataType(GdkToolDataOutputCfg config);

/**
* Returns the tool data output Type name.
*
* @public               @memberof GdkToolDataOutputCfg
* @param    config      Configuration object.
* @return               Pointer to type name.
*/
GdkFx(const kChar*) GdkToolDataOutputCfg_Type(GdkToolDataOutputCfg config);

/**
* Returns the tool data output ID.
*
* @public               @memberof GdkToolDataOutputCfg
* @param    config      Configuration object.
* @return               Tool data output configuration ID.
*/
GdkFx(k32s) GdkToolDataOutputCfg_Id(GdkToolDataOutputCfg config);

/**
* Returns the tool data output name.
*
* @public               @memberof GdkToolDataOutputCfg
* @param    config      Configuration object.
* @return               Pointer to name.
*/
GdkFx(const kChar*) GdkToolDataOutputCfg_Name(GdkToolDataOutputCfg config);

/**
* Returns tool data output enabled state.
*
* @public               @memberof GdkToolDataOutputCfg
* @param    config      Configuration object.
* @return               Enabled state.
*/
GdkFx(kBool) GdkToolDataOutputCfg_Enabled(GdkToolDataOutputCfg config);

/**
* Returns user-defined parameter set.
*
* @public               @memberof GdkToolDataOutputCfg
* @param    config      Configuration object.
* @return               Parameter set.
*/
GdkFx(GdkParams) GdkToolDataOutputCfg_Parameters(GdkToolDataOutputCfg config);

/**
* Sets the name of the data output.
*
* @public               @memberof GdkToolDataOutputCfg
* @param    config      Configuration object.
* @param    name        Name to set to.
* @return               Operation status.
*/
GdkFx(kStatus) GdkToolDataOutputCfg_SetName(GdkToolDataOutputCfg config, const kChar* name);

/**
* Sets the enabled state of the data output.
*
* @public               @memberof GdkToolDataOutputCfg
* @param    config      Configuration object.
* @param    flag        True to enable, false to disable.
* @return               Operation status.
*/
GdkFx(kStatus) GdkToolDataOutputCfg_SetEnabled(GdkToolDataOutputCfg config, kBool flag);

#endif 
