#!/usr/bin/python
# Copyright (C) 2016 by LMI Technologies Inc.  All rights reserved.
# Distributed under the terms of the MIT License.
# Redistributed files must retain the above copyright notice.

import argparse
import tarfile
import io
import xml.etree.ElementTree
import xml.dom.minidom

def AddManifest(tarFile):
    manifestElement = xml.etree.ElementTree.Element('Manifest')
    manifestElement.attrib['version'] = '0'
    fixesElement = xml.etree.ElementTree.SubElement(manifestElement, 'Fixes')

    for fixName in ['MaxNandSpare512', 'YaffsInbandTagsSupported']:
        fixeElement = xml.etree.ElementTree.SubElement(fixesElement, 'Fix')
        fixeElement.attrib['name'] = fixName

    manifestStr = xml.dom.minidom.parseString(xml.etree.ElementTree.tostring(manifestElement)).toprettyxml(indent='  ')
    manifestData = manifestStr.encode('utf-8')
    manifestObj = io.BytesIO(manifestData)
    manifestEntry = tarfile.TarInfo('Manifest.xml')
    manifestEntry.size = len(manifestData)
    tarFile.addfile(tarinfo=manifestEntry, fileobj=manifestObj)

def TarGen(kernelName, applicationName, outputName):

    with tarfile.open(outputName, 'w', format=tarfile.GNU_FORMAT) as tarFile:

        AddManifest(tarFile)
        tarFile.add(kernelName, 'Framework.bin')
        tarFile.add(applicationName, 'Application.bin')

if __name__ == '__main__':

    parser = argparse.ArgumentParser(description='Generate Zynq7k bootable tarball.')

    parser.add_argument('kernel', help='Framework binary.')
    parser.add_argument('application', help='Application binary.')
    parser.add_argument('output', help='Output file.')

    args = parser.parse_args()
    TarGen(args.kernel, args.application, args.output)
