#!/usr/bin/python
# Copyright (C) 2017 by LMI Technologies Inc.  All rights reserved.
# Distributed under the terms of the MIT License.
# Redistributed files must retain the above copyright notice.

import sys
import re
import io
import subprocess
import os

def Emit(munchSource, requiresDw2Eh, requiresModuleDtor, constructorList, destructorList):

    with io.open(munchSource, 'w') as munchObject:

        munchObject.write('/*\n')
        munchObject.write(' * Automatically generated by kMunch.py\n')
        munchObject.write(' */\n')

        if requiresDw2Eh:
            munchObject.write('extern void __register_frame_info(const void*, void*);\n')
            munchObject.write('extern void* __deregister_frame_info(const void*);\n')
            munchObject.write('extern const unsigned __EH_FRAME_BEGIN__[];\n')
            munchObject.write('\n')
            munchObject.write('static void _register_unwind_dw2_tabs()\n')
            munchObject.write('{\n')
            munchObject.write('    /*\n')
            munchObject.write('     * structure to match GCC unwind-dw2-fde.h.\n')
            munchObject.write('     */\n')
            munchObject.write('    static struct object\n')
            munchObject.write('    {\n')
            munchObject.write('        void* pc_begin; void* tbase; void* dbase; void* u;\n')
            munchObject.write('        unsigned long b; void* fde_end; struct object* next;\n')
            munchObject.write('    } object;\n')
            munchObject.write('\n')
            munchObject.write('    __register_frame_info(__EH_FRAME_BEGIN__, &object);\n')
            munchObject.write('}\n')
            munchObject.write('\n')
            munchObject.write('static void _unregister_unwind_dw2_tabs()\n')
            munchObject.write('{\n')
            munchObject.write('    __deregister_frame_info(__EH_FRAME_BEGIN__);\n')
            munchObject.write('}\n')
            munchObject.write('\n')

        munchObject.write('char __dso_handle = 0;\n')

        if requiresModuleDtor:
            munchObject.write('extern void __cxa_finalize(void *);\n')
            munchObject.write('static void _unregister_dso()\n')
            munchObject.write('{\n')
            munchObject.write('    __cxa_finalize(&__dso_handle);\n')
            munchObject.write('}\n')

        munchObject.write('\n')

        munchObject.write('\n')
        for constructor in constructorList:
            munchObject.write('void ' + constructor + '();\n')
        munchObject.write('\n')

        munchObject.write('extern void (*_ctors[])();\n')
        munchObject.write('void (*_ctors[])() =\n')
        munchObject.write('{\n')

        if requiresDw2Eh:
            munchObject.write('    _register_unwind_dw2_tabs,\n')

        for constructor in constructorList:
            munchObject.write('    ' + constructor + ',\n')

        munchObject.write('    0\n')
        munchObject.write('};\n')
        munchObject.write('\n')

        munchObject.write('\n')
        for destructor in destructorList:
            munchObject.write('void ' + destructor + '();\n')
        munchObject.write('\n')

        munchObject.write('extern void (*_dtors[])();\n')
        munchObject.write('void (*_dtors[])() =\n')
        munchObject.write('{\n')

        if requiresDw2Eh:
            munchObject.write('    _unregister_unwind_dw2_tabs,\n')

        if requiresModuleDtor:
            munchObject.write('    _unregister_dso,\n')

        for destructor in destructorList:
            munchObject.write('    ' + destructor + ',\n')

        munchObject.write('    0\n')
        munchObject.write('};\n')
        munchObject.write('\n')

def Munch(nmPath, partImagePath, munchSource):

    requiresDw2Eh = False
    requiresModuleDtor = False
    constructorList = []
    destructorList = []

    output = subprocess.check_output([nmPath, partImagePath])

    for line in output.decode('utf-8').splitlines():
        components = line.split()

        if (len(components) > 1):

            if (components[0] == 'U' and components[1] == '__gxx_personality_v0'):
                requiresDw2Eh = True

            if (components[0] == 'U' and components[1] == '__cxa_atexit'):
                requiresModuleDtor = True

            if (components[1] == 'T'):
                if (re.search(r'^__?GLOBAL_.I.', components[2]) is not None):
                    constructorList.append(components[2])
                    continue

                if (re.search(r'^__?GLOBAL_.D.', components[2]) is not None):
                    destructorList.append(components[2])
                    continue

    Emit(munchSource, requiresDw2Eh, requiresModuleDtor, constructorList, destructorList)

if __name__ == '__main__':

    Munch(sys.argv[1], sys.argv[2], sys.argv[3])
