#!/usr/bin/python
# Copyright (C) 2017 by LMI Technologies Inc.  All rights reserved.
# Distributed under the terms of the MIT License.
# Redistributed files must retain the above copyright notice.

import sys
import re
import io
import subprocess
import os

def Emit(munchSource, constructorList, destructorList):

    with io.open(munchSource, 'w') as munchObject:

        munchObject.write('/*\n')
        munchObject.write(' * Automatically generated by kCrunch.py\n')
        munchObject.write(' */\n')

        munchObject.write('\n')

        munchObject.write('\n')
        for constructor in constructorList:
            munchObject.write('void ' + constructor + '();\n')
        munchObject.write('\n')

        munchObject.write('extern void (*_ctors[])();\n')
        munchObject.write('void (*_ctors[])() =\n')
        munchObject.write('{\n')

        for constructor in constructorList:
            munchObject.write('    ' + constructor + ',\n')

        munchObject.write('    0\n')
        munchObject.write('};\n')
        munchObject.write('\n')

        munchObject.write('\n')
        for destructor in destructorList:
            munchObject.write('void ' + destructor + '();\n')
        munchObject.write('\n')

        munchObject.write('extern void (*_dtors[])();\n')
        munchObject.write('void (*_dtors[])() =\n')
        munchObject.write('{\n')

        for destructor in destructorList:
            munchObject.write('    ' + destructor + ',\n')

        munchObject.write('    0\n')
        munchObject.write('};\n')
        munchObject.write('\n')

        munchObject.write('\n')
        munchObject.write('void __cxa_end_cleanup();\n')
        munchObject.write('void _Unwind_RaiseException();\n')
        munchObject.write('void _Unwind_Resume();\n')
        munchObject.write('void _Znwj();\n')
        munchObject.write('void _ZnwjRKSt9nothrow_t();\n')
        munchObject.write('void _Znaj();\n')
        munchObject.write('void _ZnajRKSt9nothrow_t();\n')
        munchObject.write('void _ZdlPv();\n')
        munchObject.write('void _ZdaPv();\n')
        munchObject.write('void (*FSS767LinkerFix[])() =\n')
        munchObject.write('{\n')
        munchObject.write('    __cxa_end_cleanup,       /* supresses linker error "error: symbol "__cxa_end_cleanup" redefined" */\n')
        munchObject.write('    _Unwind_RaiseException,  /* supresses linker error "error: symbol "__cxa_end_cleanup" redefined" */\n')
        munchObject.write('    _Unwind_Resume,          /* supresses linker error "error: symbol "__cxa_end_cleanup" redefined" */\n')
        munchObject.write('    _Znwj,                   /* forces reference to "operator new(unsigned int)" */\n')
        munchObject.write('    _ZnwjRKSt9nothrow_t,     /* forces reference to "operator new(unsigned int, std::nothrow_t const&)" */\n')
        munchObject.write('    _Znaj,                   /* forces reference to "operator new[](unsigned int)" */\n')
        munchObject.write('    _ZnajRKSt9nothrow_t,     /* forces reference to "operator new[](unsigned int, std::nothrow_t const&)" */\n')
        munchObject.write('    _ZdlPv,                  /* forces reference to "operator delete(void*)" */\n')
        munchObject.write('    _ZdaPv,                  /* forces reference to "operator delete[](void*)" */\n')
        munchObject.write('    0\n')
        munchObject.write('};\n')
        munchObject.write('\n')

def Crunch(nmPath, partImagePath, munchSource):

    constructorList = []
    destructorList = []

    output = subprocess.check_output([nmPath, partImagePath])

    for line in output.decode('utf-8').splitlines():
        components = line.split()

        if (len(components) > 1):

            if (components[1] == 'T'):
                if (re.search(r'^__?GLOBAL_.I.', components[2]) is not None):
                    constructorList.append(components[2])
                    continue

                if (re.search(r'^__?GLOBAL_.D.', components[2]) is not None):
                    destructorList.append(components[2])
                    continue

    Emit(munchSource, constructorList, destructorList)

if __name__ == '__main__':

    Crunch(sys.argv[1], sys.argv[2], sys.argv[3])
