#ifndef LMITECH_KVISION_VS_ZPRNUCAL_H_INCLUDED
#define LMITECH_KVISION_VS_ZPRNUCAL_H_INCLUDED

#include <kApi/Utils/kUtils.h>
#include <kApi/Data/kArrayList.h>
#include <kFireSync/Data/kDataTree.h>
#include <kApi/Data/kXml.h>
#include <kApi/Data/kArray1.h>
#include <kApi/Data/kArray2.h>
#include <kApi/Data/kBytes.h>
#include <kApi/Io/kDat5Serializer.h>

#include <stdio.h>

typedef struct kVsPrnuCalStep 
{
    kArray2 white;
    kArray2 black;
} kVsPrnuCalStep;

typedef struct kVsPrnuCalClass 
{
    kObjectClass base;

    kString id;
    kString timestamp;

    k32u stepCount;
    k32u imageWidth;
    k32u imageHeight;

    kL3dCameraWindow window;

    k32u blackLevel;
    k32u gainDigital;
    k32u gainAnalog;

    kArray1 positions;
    kArray1 steps;

} kVsPrnuCalClass;

kDeclareClassEx(kVs, kVsPrnuCal, kObject)

#define kVS_PRNU_CAL_VERSION 2

kStatus kVsPrnuCal_Init(kVsPrnuCal cal, kType type, k32u stepCount, k32u imageWidth, k32u imageHeight, kAlloc allocator);
kVsFx(kStatus) kVsPrnuCal_VRelease(kVsPrnuCal cal);
kStatus kVsPrnuCal_Release(kVsPrnuCal cal);

kStatus kVsPrnuCal_ReadV01(kVsPrnuCal cal, kDataTree tree, kDataTreeItem item);
kStatus kVsPrnuCal_ReadV2(kVsPrnuCal cal, kDataTree tree, kDataTreeItem item);
kStatus kVsPrnuCal_Read(kVsPrnuCal cal, kDataTree tree, kDataTreeItem item);
kStatus kVsPrnuCal_ReadManifest(kVsPrnuCal cal, kFile file);
kStatus kVsPrnuCal_ReadBinary(kVsPrnuCal cal, kFile file);
kStatus kVsPrnuCal_Write(kVsPrnuCal cal, kDataTree tree, kDataTreeItem item);
kStatus kVsPrnuCal_WriteV1(kVsPrnuCal cal, kDataTree tree, kDataTreeItem item);
kStatus kVsPrnuCal_WriteManifest(kVsPrnuCal cal, kXml xml);
kStatus kVsPrnuCal_WriteBinary(kVsPrnuCal cal, kStream stream);


#endif /* #ifndef LMITECH_KVISION_VS_ZPRNUCAL_H_INCLUDED */
