/**
 * @file    kVsImageFilter.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_VISION_IMAGE_FILTER_X_H
#define K_VISION_IMAGE_FILTER_X_H

#include <kApi/Data/kArray1.h>
#include <kApi/Data/kArray2.h>
#include <kApi/Data/kImage.h>
#include <kVision/Common/kVision.h>

/**
* Default filter parameter settings.
*
* @relates        kVsImageFilter
* @{ */
#define kVS_IMAGE_FILTER_DEFAULT_WIDTH                  (640)
#define kVS_IMAGE_FILTER_DEFAULT_WINDOW_SIZE            (7)
#define kVS_IMAGE_FILTER_DEFAULT_BORDER_TYPE            (kVS_IMAGE_FILTER_BORDER_TYPE_REPEAT)
#define kVS_IMAGE_FILTER_DEFAULT_DATA_TYPE              (kTypeOf(k8u))
#define kVS_IMAGE_FILTER_DEFAULT_FILL_COUNT            (kVS_IMAGE_FILTER_DEFAULT_WINDOW_SIZE/2)
/** @} */

typedef struct kVsImageFilterClass 
{
    kObjectClass base;
    kSize width;
    kSize window;
    kVsImageFilterBorderType border;
    kType type;
    kArray1 vSumBuffer;
    kArray1 vCountBuffer;
    kSize fillCount;

    kImage outputImageTemp;
    kArray2 outputArrayTemp;

} kVsImageFilterClass;

typedef struct kVsImageFilterVTable
{
    kObjectVTable base;
    kStatus(kCall* VApply)(kVsImageFilter filter, kObject input, kObject output);
    kStatus(kCall* VSetup)(kVsImageFilter filter);

} kVsImageFilterVTable;

kDeclareVirtualClassEx(kVs, kVsImageFilter, kObject)

//semi-private exported functions (virtual override methods)
kVsFx(kStatus) kVsImageFilter_VRelease(kVsImageFilter filter);
kVsFx(kStatus) kVsImageFilter_VApply(kVsImageFilter filter, kObject input, kObject output);
kVsFx(kStatus) kVsImageFilter_VSetup(kVsImageFilter filter);

//non-exported (private) methods
kVsFx(kStatus) kVsImageFilter_Init(kVsImageFilter filter, kType type, kAlloc allocator);
kVsFx(kType) kVsImageFilter_DetermineSumType(kType dataType);

//cast macro

//virtual table macro

#endif  /* #ifndef K_VISION_IMAGE_FILTER_X_H */


