/**
* @file    kS3dVolumeCheckInputBlockInfo.x.h
* @brief   Declares the kS3dVolumeCheckInputBlock class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_KS3D_VOLUMECHECKINPUTBLOCKINFO_X_H
#define KVISION_KS3D_VOLUMECHECKINPUTBLOCKINFO_X_H

#include <kVision/S3d/kS3dVolumeCheckDef.h>
#include <kApi/Data/kArray1.h>
#include <kApi/Data/kXml.h>

typedef struct kS3dVolumeCheckInputBlockInfoClass 
{
    kObjectClass base;
    kText64 inputName;
    k32u chamberType;
    kPoint3d64f position;
    kPoint3d64f orientation;
    kPoint3d64f randomPosition;
    kPoint3d64f randomOrientation;
    kPoint3d64f inputScale;
    k32s dataTypeIndex;
    k32s startIndex;
    k32s measurementCount;
    k32s fileCount;
    kBool randomUsed;
    kBool saveSimulation;
} kS3dVolumeCheckInputBlockInfoClass;

kDeclareClassEx(kVs, kS3dVolumeCheckInputBlockInfo, kObject)

kVsFx(kStatus) kS3dVolumeCheckInputBlockInfo_Init(kS3dVolumeCheckInputBlockInfo info, kType classType, kAlloc alloc);
kVsFx(kStatus) kS3dVolumeCheckInputBlockInfo_VRelease(kS3dVolumeCheckInputBlockInfo info);
kVsFx(kStatus) kS3dVolumeCheckInputBlockInfo_Release(kS3dVolumeCheckInputBlockInfo info);

#endif /* #ifndef KVISION_KS3D_VOLUMECHECKINPUTBLOCKINFO_X_H  */
