/**
* @file    kS3dVolumeCheckInputBlock.x.h
* @brief   Declares the kS3dVolumeCheckInputBlock class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_KS3D_VOLUMECHECKINPUTBLOCK_X_H
#define KVISION_KS3D_VOLUMECHECKINPUTBLOCK_X_H

#include <kApi/Data/kArray2.h>
#include <kFireSync/Data/kMsg.h>
#include <kApi/Data/kBox.h>
#include <kFireSync/Pipe/kPxBlock.h>
#include <kFireSync/Pipe/kPxPort.h>
#include <kVision/L3d/kL3dChartPlotter.h>
#include <kVision/L3d/kL3dLinePalette.h>
#include <kVision/L3d/kL3dUtilities.h>
#include <kVision/S3d/kS3dVolumeCheckInputBlock.h>
#include <kVision/S3d/kS3dVolumeCheckInputBlockInfo.h>
#include <kVision/S3d/kS3dVolumeCheckAlg.h>

#define  KVISION_KS3D_VOLUMECHECK_BLOCK_SIMULATION

#include <math.h>

#define kVISION_kS3_VOLUMCHECK_INPUT_BLOCK_DESCRIPTION    "Input height map"

typedef struct kS3dVolumeCheckInputBlockClass
{
    kPxBlockClass base;

    kS3dVolumeCheckInputAlg alg;
    kPoint3d64f inputScale;
    kPort outSurface;
    kPort outputAdditional;
//    kMsgSet surfaceMsg;
    kS3dVolumeCheckInputBlockInfo settings;
    kArrayList inImages;
    kArrayList inMessages;

    k32s debugIndex;
} kS3dVolumeCheckInputBlockClass;


kDeclareClassEx(kVs, kS3dVolumeCheckInputBlock, kPxBlock)

kVsFx(const kChar*) kS3dVolumeCheckInputBlock_VDescription();
kVsFx(kStatus) kS3dVolumeCheckInputBlock_VOnSetup(kS3dVolumeCheckInputBlock block);
kVsFx(kStatus) kS3dVolumeCheckInputBlock_VOnStart(kS3dVolumeCheckInputBlock block);
kVsFx(kStatus) kS3dVolumeCheckInputBlock_VOnStop(kS3dVolumeCheckInputBlock block);
kVsFx(kStatus) kS3dVolumeCheckInputBlock_VOnReceive(kS3dVolumeCheckInputBlock block, kPort port, kMsgSet msg);
kVsFx(kStatus) kS3dVolumeCheckInputBlock_ConfigureDefaults(kS3dVolumeCheckInputBlockInfo info);
kVsFx(kStatus) kS3dVolumeCheckInputBlock_ValidateInfo(kS3dVolumeCheckInputBlockInfo info);
kVsFx(kStatus) kS3dVolumeCheckInputBlock_FreeInputs(kS3dVolumeCheckInputBlock block);

#endif /* #ifndef KVISION_KS3D_VOLUMECHECKINPUTBLOCK_X_H */
