/**
* @file    kS3dVolumeCheckBlock.x.h
* @brief   Declares the kS3dVolumeCheckBlock class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_KS3D_VOLUMECHECKBLOCK_X_H
#define KVISION_KS3D_VOLUMECHECKBLOCK_X_H

#include <kApi/Data/kArray2.h>
#include <kFireSync/Data/kMsg.h>
#include <kApi/Data/kBox.h>
#include <kFireSync/Pipe/kPxBlock.h>
#include <kFireSync/Pipe/kPxPort.h>
#include <kVision/L3d/kL3dChartPlotter.h>
#include <kVision/L3d/kL3dLinePalette.h>
#include <kVision/L3d/kL3dUtilities.h>
#include <kVision/S3d/kS3dVolumeCheckBlock.h>
#include <kVision/S3d/kS3dVolumeCheckBlockInfo.h>
#include <kVision/S3d/kS3dVolumeCheckAlg.h>

#define  KVISION_KS3D_VOLUMECHECK_BLOCK_SIMULATION

#include <math.h>

#define kVISION_kS3_VOLUMCHECK_BLOCK_DESCRIPTION    "Combustion chamber volume"

typedef struct kS3dVolumeCheckBlockClass
{
    kPxBlockClass base;

    kS3dVolumeCheckAlg alg;
    kS3dVolumeCheckSubPixLut subPixLut;
    kPoint3d64f inputScale;
    kRect3d64f defaultFov;
    kPoint3d64f defaultDataOrigin;
    kPort outputVolume;
    kPort outputValves;
    kPort outPlot;
    kPort outReport;
    kMsg surfaceMsg;
    kString reportString;
    kS3dVolumeCheckBlockInfo settings;
    kS3dVolumeCheckDefaultChamberType chamberType;

#ifdef KVISION_KS3D_VOLUMECHECK_BLOCK_SIMULATION
    kMsg additionalMsg;
    kBool hasAdditional;
#endif

} kS3dVolumeCheckBlockClass;


kDeclareClassEx(kVs, kS3dVolumeCheckBlock, kPxBlock)

kVsFx(const kChar*) kS3dVolumeCheckBlock_VDescription();
kVsFx(kStatus) kS3dVolumeCheckBlock_VOnSetup(kS3dVolumeCheckBlock block);
kVsFx(kStatus) kS3dVolumeCheckBlock_VOnStart(kS3dVolumeCheckBlock block);
kVsFx(kStatus) kS3dVolumeCheckBlock_VOnStop(kS3dVolumeCheckBlock block);
kVsFx(kStatus) kS3dVolumeCheckBlock_VOnReceive(kS3dVolumeCheckBlock block, kPort port, kMsgSet msg);
kVsFx(kStatus) kS3dVolumeCheckBlock_ConfigureDefaults(kS3dVolumeCheckBlockInfo info, kS3dVolumeCheckDefaultChamberType type);
kVsFx(kStatus) kS3dVolumeCheckBlock_ValidateInfo(kS3dVolumeCheckBlockInfo info);
kVsFx(kStatus) kS3dVolumeCheckBlock_FreeInputs(kS3dVolumeCheckBlock block);
kVsFx(kStatus) kS3dVolumeCheckBlock_StudPlot(kS3dVolumeCheckBlock block, kArray2 surface, kPoint3d64f* centerPt, kPlot* outPlot);

#endif /* #ifndef KVISION_KS3D_VOLUMECHECKBLOCK_X_H */
