/**
* @file    kS3dSpeckleDisparityFilter.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef KS3D_SPECKLE_DISPARITY_FILTER_X_H
#define KS3D_SPECKLE_DISPARITY_FILTER_X_H

#include <math.h>

#define kS3D_SPECKLE_DISPARITY_FILTER_DEFAULT_REGION_MIN_COUNT         (10)
#define kS3D_SPECKLE_DISPARITY_FILTER_DEFAULT_REGION_STEP_THRESHOLD    (1)
#define kS3D_SPECKLE_DISPARITY_FILTER_DEFAULT_REGION_STEP_THRESHOLD    (1)

// These have to be configured to match the pre-filtering and block matching settings.
#define kS3D_SPECKLE_DISPARITY_FILTER_DEFAULT_BIT_DEPTH                (1)
#define kS3D_SPECKLE_DISPARITY_FILTER_DEFAULT_FILTER_CAP               (127)

#define kS3D_SPECKLE_DISPARITY_FILTER_DEFAULT_SMOOTH_WINDOW            (5)
#define kS3D_SPECKLE_DISPARITY_FILTER_DEFAULT_SMOOTH_MIN_FILL_RATIO    (0.5)

typedef struct kS3dSpeckleDisparityFilterClass
{
    kObjectClass base;

    // Algorithm parameters
    kSize imageWidth;
    kSize imageHeight;

    k32u regionMinCount;
    k32u regionStepThreshold;
    k32u filterCap;
    k32u bitDepth;
    k32u smoothWindow;
    k64f smoothMinFillRatio;

    // Algorithm data

    kArrayList outlierBuffer;
    kArrayList vSumBuffer;
    kArrayList vCountBuffer;

    kArray2 smoothDisparityTemp;

} kS3dSpeckleDisparityFilterClass;

kDeclareClassEx(kVs, kS3dSpeckleDisparityFilter, kObject)

//semi-private exported functions (virtual override methods)

kVsFx(kStatus) kS3dSpeckleDisparityFilter_VInitClone(kS3dSpeckleDisparityFilter filter, kS3dSpeckleDisparityFilter source, kAlloc allocator);
kVsFx(kStatus) kS3dSpeckleDisparityFilter_VRelease(kS3dSpeckleDisparityFilter filter);

//non-exported (private) methods
kStatus kS3dSpeckleDisparityFilter_Init(kS3dSpeckleDisparityFilter filter, kAlloc allocator);

//cast macro

#endif  /* #ifndef KS3D_SPECKLE_DISPARITY_FILTER_X_H */
