/**
* @file     kS3dSingleSphereAlg.h
* @brief    Declares the kS3d single sphere algorithm class
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/

#ifndef kS3D_SINGLE_SPHERE_ALG_H
#define kS3D_SINGLE_SPHERE_ALG_H

#include <kVision/Common/kVision.h>
#include <kFireSync/Data/kPlot.h>

typedef kObject kS3dSingleSphereAlg;

kVsFx(kStatus) kS3dSingleSphereAlg_Construct(kS3dSingleSphereAlg* alg, kAlloc allocator);
kVsFx(kStatus) kS3dSingleSphereAlg_Reset(kS3dSingleSphereAlg alg);

kVsFx(kStatus) kS3dSingleSphereAlg_Run(kS3dSingleSphereAlg alg, kArray2 heightMap);
kVsFx(kStatus) kS3dSingleSphereAlg_Plot2d(kS3dSingleSphereAlg alg, kArray2 heightMap, kPlot* plot);
kVsFx(kPoint3d64f) kS3dSingleSphereAlg_SphereCenter(kS3dSingleSphereAlg alg);
kVsFx(k64f) kS3dSingleSphereAlg_SphereRadius(kS3dSingleSphereAlg alg);
kVsFx(kBool) kS3dSingleSphereAlg_SphereDetected(kS3dSingleSphereAlg alg);
kVsFx(kArray2) kS3dSingleSphereAlg_RadialError(kS3dSingleSphereAlg alg);
kVsFx(kArray2) kS3dSingleSphereAlg_SmoothRadialError(kS3dSingleSphereAlg alg);
kVsFx(k64f) kS3dSingleSphereAlg_Coverage(kS3dSingleSphereAlg alg);
kVsFx(k64f) kS3dSingleSphereAlg_SpatialNoise(kS3dSingleSphereAlg alg);
kVsFx(k64f) kS3dSingleSphereAlg_MinRadialError(kS3dSingleSphereAlg alg);
kVsFx(k64f) kS3dSingleSphereAlg_MaxRadialError(kS3dSingleSphereAlg alg);

kVsFx(kStatus) kS3dSingleSphereAlg_SetMapHeight(kS3dSingleSphereAlg alg, kSize height);
kVsFx(kSize) kS3dSingleSphereAlg_MapHeight(kS3dSingleSphereAlg alg);
kVsFx(kStatus) kS3dSingleSphereAlg_SetMapWidth(kS3dSingleSphereAlg alg, kSize width);
kVsFx(kSize) kS3dSingleSphereAlg_MapWidth(kS3dSingleSphereAlg alg);
kVsFx(kStatus) kS3dSingleSphereAlg_SetFitOrder(kS3dSingleSphereAlg alg, kSize fitOrder);
kVsFx(kSize) kS3dSingleSphereAlg_FitOrder(kS3dSingleSphereAlg alg);
kVsFx(kSize) kS3dSingleSphereAlg_PointCount(kS3dSingleSphereAlg alg);

#include <kVision/S3d/kS3dSingleSphereAlg.x.h>

#endif /* #ifndef kS3D_SINGLE_SPHERE_ALG_H */
