/**
* @file     kS3dScanResult.h
* @brief    Declares the kS3d Scan class
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/

#ifndef kS3D_SCAN_RESULT_H
#define kS3D_SCAN_RESULT_H

#include <kVision/Common/kVision.h>
#include <kFireSync/Data/kPlot.h>
#include <kFireSync/Data/kDataTree.h>

typedef kObject kS3dScanResult;

kVsFx(kStatus) kS3dScanResult_Construct(kS3dScanResult* result, kAlloc allocator);

kVsFx(kStatus) kS3dScanResult_Load(kS3dScanResult* result, const kChar* fileName, kAlloc allocator);
kVsFx(kStatus) kS3dScanResult_Save(kS3dScanResult result, const kChar* fileName);

kVsFx(kStatus) kS3dScanResult_SetRangeResolution(kS3dScanResult result, k64f rangeResolution);
kVsFx(k64f) kS3dScanResult_RangeResolution(kS3dScanResult result);

kVsFx(kStatus) kS3dScanResult_SetLookupType(kS3dScanResult result, k32u lookupType);
kVsFx(k32u) kS3dScanResult_LookupType(kS3dScanResult result);

kVsFx(kStatus) kS3dScanResult_SetPoints64f(kS3dScanResult result, kArray2 points64f);
kVsFx(kStatus) kS3dScanResult_SetPoints16s(kS3dScanResult result, kArray2 points16s);
kVsFx(kStatus) kS3dScanResult_SetHeightMap(kS3dScanResult result, kArray2 heightMap);

kVsFx(kArray2) kS3dScanResult_Points64f(kS3dScanResult result);
kVsFx(kArray2) kS3dScanResult_Points16s(kS3dScanResult result);
kVsFx(kArray2) kS3dScanResult_HeightMap(kS3dScanResult result);

#include <kVision/S3d/kS3dScanResult.x.h>

#endif /* #ifndef kS3D_SCAN_RESULT_H */
