/**
* @file     kS3dScanInput.h
* @brief    Declares the kS3d Scan class
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/

#ifndef kS3D_SCAN_INPUT_H
#define kS3D_SCAN_INPUT_H

#include <kVision/Common/kVision.h>
#include <kFireSync/Data/kPlot.h>
#include <kFireSync/Data/kDataTree.h>
#include <kFireSync/kNodeDef.h>
#include <kFireSync/kFsDef.h>

typedef kObject kS3dScanInput;

kVsFx(kStatus) kS3dScanInput_Construct(kS3dScanInput* scan, kAlloc allocator);

kVsFx(kStatus) kS3dScanInput_Load(kS3dScanInput* scan, const kChar* fileName, kAlloc allocator);
kVsFx(kStatus) kS3dScanInput_Save(kS3dScanInput scan, const kChar* fileName);

kVsFx(kStatus) kS3dScanInput_SetId(kS3dScanInput scan, kSize id);
kVsFx(kSize) kS3dScanInput_Id(kS3dScanInput scan);

kVsFx(kStatus) kS3dScanInput_SetTimestamp(kS3dScanInput scan, const kChar* timestamp);
kVsFx(const kChar*) kS3dScanInput_Timestamp(kS3dScanInput scan);

kVsFx(kSize) kS3dScanInput_Count(kS3dScanInput scan);
kVsFx(kStatus) kS3dScanInput_Add(kS3dScanInput scan, kMsgSource source, kMsg message);
kVsFx(kStatus) kS3dScanInput_Clear(kS3dScanInput scan);

kVsFx(kMsg) kS3dScanInput_MessageAt(kS3dScanInput scan, kSize index);
kVsFx(kMsgSource) kS3dScanInput_SourceAt(kS3dScanInput scan, kSize index);

#include <kVision/S3d/kS3dScanInput.x.h>

#endif /* #ifndef kS3D_SCAN_INPUT_H */
