#ifndef kS3D_PHASE_EXPAND_X_H
#define kS3D_PHASE_EXPAND_X_H

#include <kVision/Vs/kVsJobQueue.h>

#define kS3D_PHASE_EXPAND_DEFAULT_REPEAT 10

typedef struct kS3dPhaseExpandClass
{
    kObjectClass base;
    kArray2 map;
    kArray2 data;
    kVsJobQueue jobQueue;
    k32s repeat;
    k32s phaseWidth;
    k32s limitIndex;
    k32s imageSizeX;
    k32s imageSizeY;

    k32s corrCount[16];
    k32s sumCount;
    k32s threshold;
    k32s viewIndex;
} kS3dPhaseExpandClass;

kDeclareClassEx(kVs, kS3dPhaseExpand, kObject)

kVsFx(kStatus) kS3dPhaseExpand_VInitClone(kS3dPhaseExpand expand, kS3dPhaseExpand source, kAlloc allocator);
kVsFx(kStatus) kS3dPhaseExpand_VRelease(kS3dPhaseExpand expand);
kVsFx(kSize)   kS3dPhaseExpand_VSize(kS3dPhaseExpand expand);

kStatus kS3dPhaseExpand_Init(kS3dPhaseExpand expand, kType classType, kAlloc alloc);

kStatus kS3dPhaseExpand_Row(kS3dPhaseExpand expand);
kStatus kCall kS3dPhaseExpand_RowHandler(kS3dPhaseExpand expand, k64u id);
kStatus kS3dPhaseExpand_RowThread(kS3dPhaseExpand expand, k32s* corrCount, kSize startRow, kSize rowCount);

kStatus kS3dPhaseExpand_ColumnToBottom(kS3dPhaseExpand expand);
kStatus kCall kS3dPhaseExpand_ColumnToBottomHandler(kS3dPhaseExpand expand, k64u id);
kStatus kS3dPhaseExpand_ColumnToBottomThread(kS3dPhaseExpand expand, k32s* corrCount, kSize startRow, kSize rowCount);

kStatus kS3dPhaseExpand_ColumnToTop(kS3dPhaseExpand expand);
kStatus kCall kS3dPhaseExpand_ColumnToTopHandler(kS3dPhaseExpand expand, k64u id);
kStatus kS3dPhaseExpand_ColumnToTopThread(kS3dPhaseExpand expand, k32s* corrCount, kSize startRow, kSize rowCount);

kStatus kS3dPhaseExpand_SetJobQueue(kS3dPhaseExpand expand, kVsJobQueue queue);

#endif
