/**
* @file    kS3dPhaseBlockInfo.x.h
*
* @internal
* Copyright (C) 2014-2022 by LMI Technologies Inc. All rights reserved.
*/
#ifndef kS3D_PHASE_BLOCK_INFO_X_H
#define kS3D_PHASE_BLOCK_INFO_X_H

#include <kVision/L3d/kL3dCommon.h>

typedef struct kS3dPhaseBlockInfoClass
{
    kObjectClass base;

    // profiler settings //
    kText256 calFileName;
    k64f rangeResolution;
    kRect3d64f activeAreaRoi;

    kL3dTransform3d transform;
    kL3dCameraWindow window0;
    kL3dCameraWindow window1;

    // Format and compression //
    kSize phaseDecoderFormat;          // kCameraPhaseDecoderFormat [kCAMERA_PHASE_DECODER_FORMAT_I8P24 = 4, kCAMERA_PHASE_DECODER_FORMAT_DELTA_I8_P24 = 8]
    kSize subframeCount;               // for compression only
    
    kSize encodeType;                  // kS3dEncodeType[kS3D_ENCODE_TYPE_STRIPE = 0, kS3D_ENCODE_TYPE_EMBEDDED_PHASE = 1]
    kBool imageInputEnabled;
    kBool cudaEnabled;
    kBool intensityEnabled;

    // processor settings //
    k64f ySampleBegin;
    k64f ySampleStep;
    kSize yCount;

    kSize phasePeriodSampleCount;
    kSize phaseBeginSample;
    kSize phaseCount;

    kSize lookupType;
    kSize parallelCount;


    // Stripe //
    kSize referenceImageCount;
    kSize stripeImageCount;
    kSize phaseImageCount;
    kSize sequenceCount;

    // EPS //
    kSize embeddedPhasePeriodCount;
    kArray1 embeddedPhaseCoefficients; // k64f
    kArray1 embeddedPhaseImageCounts;  // kSize

    // Common //
    kSize stripeContrastThreshold;
    kSize phaseContrastThreshold;

} kS3dPhaseBlockInfoClass;

kDeclareClassEx(kVs, kS3dPhaseBlockInfo, kObject)

kVsFx(kStatus) kS3dPhaseBlockInfo_Init(kS3dPhaseBlockInfo info, kType type, kAlloc alloc);
kVsFx(kStatus) kS3dPhaseBlockInfo_VRelease(kS3dPhaseBlockInfo info);

#endif
