/**
 * @file    kS3dPatternSequence.x.h
 *
 * @internal
 * Copyright (C) 2017-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kS3D_PATTERN_SEQUENCE_X_H
#define kS3D_PATTERN_SEQUENCE_X_H

 //TODO add any #includes here

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef enum
{
    kS3D_PATTERN_BLOCK_UNDEFINED = 0,
    kS3D_PATTERN_BLOCK_REFERENCE,
    kS3D_PATTERN_BLOCK_STRIPE,
    kS3D_PATTERN_BLOCK_PHASE
} kS3dPatternBlockType;

typedef struct kS3dPatternBlock
{
    kSize type;   // kS3dPatternBlockType

    kSize count;  // image count aka number of steps
    k64f period;  // period of the phase or finest stripe

} kS3dPatternBlock;

kDeclareValueEx(kVs, kS3dPatternBlock, kValue)

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dPatternSequenceClass
{
    kObjectClass base;

    kSize width;
    k64f intensity;
    k64f uniformity;

    kArrayList patternBlocks;
    kArray1 uniformityScale; // can be local to Render() function, will have to pass it around to all the Render_XXX() functions

} kS3dPatternSequenceClass;

kDeclareClassEx(kVs, kS3dPatternSequence, kObject)

//////////////////////////////////////////////////////////////////////////
//semi-private exported functions (virtual override methods)
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kS3dPatternSequence_VInitClone(kS3dPatternSequence pattern, kS3dPatternSequence source, kAlloc allocator);
kVsFx(kStatus) kS3dPatternSequence_VRelease(kS3dPatternSequence pattern);

//////////////////////////////////////////////////////////////////////////
//non-exported (private) methods
//////////////////////////////////////////////////////////////////////////

kStatus kS3dPatternSequence_Init(kS3dPatternSequence pattern, kSize width, kAlloc allocator);

kStatus kS3dPatternSequence_UpdateUniformity(kS3dPatternSequence pattern);

// Block //
kStatus kS3dPatternBlock_Init(kS3dPatternBlock* block, kS3dPatternBlockType type, kSize count, k64f period);

// Construct //
kStatus kS3dPatternSequence_AddReference(kS3dPatternSequence pattern, kSize count);
kStatus kS3dPatternSequence_AddStripe(kS3dPatternSequence pattern, k64f period, kSize count);
kStatus kS3dPatternSequence_AddPhase(kS3dPatternSequence pattern, k64f period, kSize count);

// Render //
kStatus kS3dPatternSequence_RenderBlock(kS3dPatternSequence pattern, kS3dPatternBlock* block, kSize row, kArray2 data);
kStatus kS3dPatternSequence_RenderReference(kS3dPatternSequence pattern, kSize count, kSize row, kArray2 data);
kStatus kS3dPatternSequence_RenderStripe(kS3dPatternSequence pattern, kSize count, k64f period, kSize row, kArray2 data);
kStatus kS3dPatternSequence_RenderPhase(kS3dPatternSequence pattern, kSize count, k64f period, kSize row, kArray2 data);

//////////////////////////////////////////////////////////////////////////
//cast macro
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif  /* #ifndef kS3D_PATTERN_SEQUENCE_X_H */
