/**
* @file    kS3dMonoMergeRigidAlgV2.h
* @brief   Declares the kS3dMonoMergeRigidAlgV2 class. 
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

//////////////////////////////////////////////////////////////////////////
// This alg is not evaluated or tested
// Should add a comparison to kS3dMonoMergeRigidAlgV2
//////////////////////////////////////////////////////////////////////////

#ifndef kS3D_MONO_MERGE_RIGID_ALG_V2_H
#define kS3D_MONO_MERGE_RIGID_ALG_V2_H

#include <kVision/S3d/kS3dCommon.h>
#include <kVision/S3d/kS3dVolumeCheckUtilities.h>
#include <kVision/S3d/kS3dVolumeCheckLowPass.h>
#include <kVision/S3d/kS3dOmcFile.h>

#define kS3D_MONO_MERGE_RIGID_BIT0             (1) 
#define kS3D_MONO_MERGE_RIGID_BIT1             (2)
#define kS3D_MONO_MERGE_RIGID_BIT3             (3) 
#define kS3D_MONO_MERGE_EDGE_WINDOW_MIN        (10) 
#define kS3D_MONO_MERGE_RIGID_BIT7             (7) 
#define kS3D_MONO_MERGE_RIGID_BIT15            (15) 

/**
* @class       kS3dMonoMergeRigidAlgV2
* @extends     kObject
* @ingroup     kVision-M3d
* @brief       Class for the merge of mono and stereo data by using rigid body transformation.
*
* There are 7 unknowns to be determined in the calculation: 6-degrees of freedom for spatial transformation 
* plus one coefficient for the scaling in z direction. Three corrections are performed for each point of mono data:
*
* 1.  Rigid body transformation;
* 2.  Rescaling of each point of mono data in the z direction;
* 3.  Weighted combination of points at the edge of the stereo data. Because the stereo data with one camera 
*     at the border is due to calibration problem often not reliable as the corresponding mono data on the same location.
*/
typedef kObject kS3dMonoMergeRigidAlgV2;

/**
* Constructs a kS3dMonoMergeRigidAlgV2 object
*
* @public              @memberof kS3dMonoMergeRigidAlgV2
* @param   alg         Destination for the constructed object handle.
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kS3dMonoMergeRigidAlgV2_Construct(kS3dMonoMergeRigidAlgV2* alg, kAlloc allocator);


/**
* Set step to speed up the calculation Default value: 2.
*
* @public              @memberof kS3dMonoMergeRigidAlgV2
* @param   alg         kS3dMonoMergeRigidAlgV2 object.
* @param   step        Resample step. Default value: 2
* @return              Operation status.
*/
kVsFx(kStatus) kS3dMonoMergeRigidAlgV2_SetStep(kS3dMonoMergeRigidAlgV2 alg, k32s step);

/**
* Get step to speed up the calculation.
*
* @public              @memberof kS3dMonoMergeRigidAlgV2
* @param   alg         kS3dMonoMergeRigidAlgV2 object.
* @return              Resample step.
*/
kVsFx(k32s) kS3dMonoMergeRigidAlgV2_Step(kS3dMonoMergeRigidAlgV2 alg);


/**
* Start the mono data correction with the rigid transformation
*
* @public              @memberof kS3dMonoMergeRigidAlgV2
* @param   alg         kS3dMonoMergeRigidAlgV2 object.
* @param   stereo      Stereo data: kArray2 <kPoint3d16s>   
* @param   mono0       Mono 0 data: kArray2 <kPoint3d16s>     
* @param   mono1       Mono 1 data: kArray2 <kPoint3d16s>      
* @param   medianWidth Median filter window
* @return              Operation status.
*/
kVsFx(kStatus) kS3dMonoMergeRigidAlgV2_Run(kS3dMonoMergeRigidAlgV2 alg, kArray2 stereo, kArray2 mono0, kArray2 mono1, k32s medianWidth);


/**  Set smooth window size refer to output size in pixel. 
*
* @public              @memberof kS3dMonoMergeRigidAlgV2
* @param   alg         kS3dMonoMergeRigidAlgV2 object.
* @param   window      Smooth window size
* @return              Operation status.
*/
kVsFx(kStatus) kS3dMonoMergeRigidAlgV2_SetSmoothWindow(kS3dMonoMergeRigidAlgV2 alg, k32s window);

/**  Get smooth window size refer to output size in pixel.
*
* @public              @memberof kS3dMonoMergeRigidAlgV2
* @param   alg         kS3dMonoMergeRigidAlgV2 object.
* @return              Smooth window size
*/
kVsFx(k32s) kS3dMonoMergeRigidAlgV2_SmoothWindow(kS3dMonoMergeRigidAlgV2 alg);

/**  Set option to fit the scale of mono data in z direction.
*
* @public              @memberof kS3dMonoMergeRigidAlgV2
* @param   alg         kS3dMonoMergeRigidAlgV2 object.
* @param   used        The fitting should be performed?
* @return              Operation status.
*/
kVsFx(kStatus) kS3dMonoMergeRigidAlgV2_SetScaleCorrectionUsed(kS3dMonoMergeRigidAlgV2 alg, kBool used);

/**  Get the setting of option to fit the scale of mono data in z direction.
*
* @public              @memberof kS3dMonoMergeRigidAlgV2
* @param   alg         kS3dMonoMergeRigidAlgV2 object.
* @return              Is the scale fitting used?
*/
kVsFx(kBool) kS3dMonoMergeRigidAlgV2_ScaleCorrectionUsed(kS3dMonoMergeRigidAlgV2 alg);


/**  Set the threshold to determine whether a point is valid or an outlier.
*
* @public              @memberof kS3dMonoMergeRigidAlgV2
* @param   alg         kS3dMonoMergeRigidAlgV2 object.
* @param   maxDelta    threshold value. 
* @return              Operation status.
*/

kVsFx(kStatus) kS3dMonoMergeRigidAlgV2_SetMaxDelta(kS3dMonoMergeRigidAlgV2 alg, k32s maxDelta);

#include <kVision/S3d/kS3dMonoMergeRigidAlgV2.x.h>

#endif /* #ifndef kS3D_MONO_MERGE_RIGID_ALG_V2_H */
