/**
 * @file    kS3dMonoMergeAlg.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kVS_MONO_MERGE_ALG_X_H
#define kVS_MONO_MERGE_ALG_X_H

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#define kVS_MONO_MERGE_SHIFT      (30)     // k64f to k64s (scale = 1 << kVS_MONO_MERGE_SHIFT)
#define kVS_MONO_MERGE_NEIGHBORS  (4)      // num neighbors for each point in grid

// TRANSFORM //
//#define kVS_MONO_MERGE_TRANSFORM_AFFINE 
//#define kVS_MONO_MERGE_TRANSFORM (4)

#define kVS_MONO_MERGE_TRANSFORM_QUADRATIC 
#define kVS_MONO_MERGE_TRANSFORM  (10)      // 10x3 transformation matrix kX

typedef struct kS3dMonoMergeAlgClass
{
    kObjectClass base;

    kArray2 sourceIds;

    kSize lineCount;
    kSize lineWidth;

    kSSize neighRow[kVS_MONO_MERGE_NEIGHBORS];
    kSSize neighCol[kVS_MONO_MERGE_NEIGHBORS];

    // TRANSFORM //
    kArrayList transformSource; // kPoint3d16s
    kArrayList transformTarget; // kPoint3d16s

    // KA * KX = KB
    kArray2 kX;
    //kArray2 KA, KX, KB;

    k64f outlierTolerance; // average multiplier
    k64f monoDiff;   // % for mono1 to show up instead of mono0
    k64f stereoDiff; // % for stereo of Max(mono0, mono1) to be considered valid

} kS3dMonoMergeAlgClass;

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kDeclareClassEx(kVs, kS3dMonoMergeAlg, kObject)

//////////////////////////////////////////////////////////////////////////
//semi-private exported functions (virtual override methods)
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kS3dMonoMergeAlg_VInitClone(kS3dMonoMergeAlg alg, kS3dMonoMergeAlg source, kAlloc allocator);
kVsFx(kStatus) kS3dMonoMergeAlg_VRelease(kS3dMonoMergeAlg alg);
kVsFx(kSize) kS3dMonoMergeAlg_VSize(kS3dMonoMergeAlg alg);

//////////////////////////////////////////////////////////////////////////
//non-exported (private) methods
//////////////////////////////////////////////////////////////////////////

kStatus kS3dMonoMergeAlg_Init(kS3dMonoMergeAlg alg, kAlloc allocator);

kStatus kS3dMonoMergeAlg_Setup(kS3dMonoMergeAlg alg, kSize lineCount, kSize lineWidth);

kStatus kS3dMonoMergeAlg_InitSourceIds(kS3dMonoMergeAlg alg, kArray2 stereo, kArray2 mono);
kStatus kS3dMonoMergeAlg_ExpandBfs(kS3dMonoMergeAlg alg, kArray2 stereo, k8s stopCondition);

// Detect boundaries (seems) between stereo and mono grids for align and blend algorithms.
kStatus kS3dMonoMergeAlg_DetectBlendRegions(kS3dMonoMergeAlg alg, kArray2 stereo, kArray2 mono);

// Aligns mono point array(grid) to stereo point array(grid) using quadratic alignment algorithm.
kStatus kS3dMonoMergeAlg_AlignQuadratic(kS3dMonoMergeAlg alg, kArray2 stereo, kArray2 mono);

// Combine mono point array(grid) to stereo point array(grid).
kStatus kS3dMonoMergeAlg_SimpleCombine(kS3dMonoMergeAlg alg, kArray2 stereo, kArray2 mono);

// TRANSFORM //
kStatus kS3dMonoMergeAlg_InitPairs(kS3dMonoMergeAlg alg, kArray2 stereo, kArray2 mono);

kStatus kS3dMonoMergeAlg_InitKA(kS3dMonoMergeAlg alg, kArray2 KA);
kStatus kS3dMonoMergeAlg_InitKB(kS3dMonoMergeAlg alg, kArray2 KB);

kStatus kS3dMonoMergeAlg_TransformMono(kS3dMonoMergeAlg alg, kArray2 mono);

//cast macro

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kInlineFx(kStatus) kS3dMonoMergeAlg_SetOutlierTolerance(kS3dMonoMergeAlg alg, k64f tol)
{
    kObj(kS3dMonoMergeAlg, alg);

    obj->outlierTolerance = tol;

    return kOK;
}

kInlineFx(kStatus) kS3dMonoMergeAlg_OutlierTolerance(kS3dMonoMergeAlg alg, k64f* tol)
{
    kObj(kS3dMonoMergeAlg, alg);

    *tol = obj->outlierTolerance;

    return kOK;
}

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif  /* #ifndef kVS_MONO_MERGE_ALG_X_H */
