#ifndef LMITECH_KVISION_S3D_IMAGE_LOADER_BLOCK_INFO_H_INCLUDED
#define LMITECH_KVISION_S3D_IMAGE_LOADER_BLOCK_INFO_H_INCLUDED

#include <kVision/S3d/kS3dCommon.h>
#include <kVision/L3d/kL3dTransform3d.h>

#define kS3D_IMAGE_LOADER_BLOCK_NAME                 "ImgLoad"
#define kS3D_IMAGE_LOADER_BLOCK_TYPE_NAME            "kS3dImageLoaderBlock"

#define kS3D_IMAGE_LOADER_BLOCK_INDATA_NAME         "InData"
#define kS3D_IMAGE_LOADER_BLOCK_OUTIMAGE0_NAME      "OutImage0"
#define kS3D_IMAGE_LOADER_BLOCK_OUTIMAGE1_NAME      "OutImage1"

typedef enum
{
    kS3D_IMAGE_LOADER_BLOCK_INDATA = 0,
    kS3D_IMAGE_LOADER_BLOCK_OUTIMAGE0 = 1,
    kS3D_IMAGE_LOADER_BLOCK_OUTIMAGE1 = 2
} ImageLoaderBlockPort;

typedef kPointer kS3dImageLoaderBlockInfo;

kVsFx(kStatus) kS3dImageLoaderBlockInfo_Construct(kS3dImageLoaderBlockInfo * info);
kVsFx(kStatus) kS3dImageLoaderBlockInfo_Load(kS3dImageLoaderBlockInfo * info, kXml xml);
kVsFx(kStatus) kS3dImageLoaderBlockInfo_Destroy(kS3dImageLoaderBlockInfo info);
kVsFx(kStatus) kS3dImageLoaderBlockInfo_Store(kS3dImageLoaderBlockInfo info, kXml* xml);

kVsFx(kStatus) kS3dImageLoaderBlockInfo_Read(kS3dImageLoaderBlockInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kS3dImageLoaderBlockInfo_Write(kS3dImageLoaderBlockInfo info, kXml xml, kXmlItem item);

kVsFx(kStatus) kS3dImageLoaderBlockInfo_SetImages0FileName(kS3dImageLoaderBlockInfo info, const kChar* name);
kVsFx(kStatus) kS3dImageLoaderBlockInfo_SetImages1FileName(kS3dImageLoaderBlockInfo info, const kChar* name);

kVsFx(const kChar*) kS3dImageLoaderBlockInfo_Images0FileName(kS3dImageLoaderBlockInfo info);
kVsFx(const kChar*) kS3dImageLoaderBlockInfo_Images1FileName(kS3dImageLoaderBlockInfo info);

#endif /* #ifndef LMITECH_KVISION_S3D_IMAGE_LOADER_BLOCK_INFO_H_INCLUDED */
