/** 
 * @file    kP3dLutActionInfo.h
 * @brief   Declares the kP3dLutActionInfo class. 
 * 
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef LMITECH_KVISION_P3D_LUT_ACTION_INFO_H_INCLUDED
#define LMITECH_KVISION_P3D_LUT_ACTION_INFO_H_INCLUDED

#include <kVision/Common/kVision.h>
#include <kApi/Data/kXml.h>
#include <kVision/L3d/kL3dTransform2d.h>

/**
 * @class   kP3dLutActionInfo
 * @ingroup kVision
 * @brief   Settings for kP3dLutAction.
 */
typedef kObject kP3dLutActionInfo; 

typedef enum
{
    kP3D_LUT_ACTION_TEST_PATTERN_REDUCE   = 0x01,
    kP3D_LUT_ACTION_TEST_PATTERN_OFFSET   = 0x02,
    kP3D_LUT_ACTION_TEST_PATTERN_DECIMATE = 0x04
} kP3dLutWriterTestPattern;

kVsFx(kStatus) kP3dLutActionInfo_Construct(kP3dLutActionInfo* info, kAlloc allocator);

kVsFx(kStatus) kP3dLutActionInfo_Load(kP3dLutActionInfo* info, kXml xml, kAlloc allocator);
kVsFx(kStatus) kP3dLutActionInfo_Store(kP3dLutActionInfo info, kXml* xml, kAlloc allocator);

kVsFx(kStatus) kP3dLutActionInfo_Write(kP3dLutActionInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kP3dLutActionInfo_Read(kP3dLutActionInfo info, kXml xml, kXmlItem item);

kVsFx(kStatus) kP3dLutActionInfo_Clear(kP3dLutActionInfo info); 
kVsFx(kStatus) kP3dLutActionInfo_Validate(kP3dLutActionInfo info); 

kVsFx(const kChar*) kP3dLutActionInfo_CalFileName(kP3dLutActionInfo info);
kVsFx(kStatus) kP3dLutActionInfo_SetCalFileName(kP3dLutActionInfo info, const kChar* calFileName);

/**
* Returns the Test Pattern
*
* @public              @memberof kP3dLutActionInfo
* @param   info        Info object.
* @return              TestPattern
*/
kVsFx(k32s) kP3dLutActionInfo_TestPattern(kP3dLutActionInfo info);

/**
*
* @public              @memberof kP3dLutActionInfo
* @param   info        Info object.
* @param   pattern     Test pattern value. May be ORed together
* @return              Operation status.
*/
kVsFx(kStatus) kP3dLutActionInfo_SetTestPattern(kP3dLutActionInfo info, k32s pattern);

kVsFx(k32u) kP3dLutActionInfo_IntensityMultiplier(kP3dLutActionInfo info);
kVsFx(kStatus) kP3dLutActionInfo_SetIntensityMultiplier(kP3dLutActionInfo info, k32u multiplier);

kVsFx(k32u) kP3dLutActionInfo_ViewIndex(kP3dLutActionInfo info);
kVsFx(kStatus) kP3dLutActionInfo_SetViewIndex(kP3dLutActionInfo info, k32u index);

kVsFx(k64f) kP3dLutActionInfo_RangeScale(kP3dLutActionInfo info);
kVsFx(kStatus) kP3dLutActionInfo_SetRangeScale(kP3dLutActionInfo info, k64f rangeScale);

kVsFx(const kL3dTransform2d*) kP3dLutActionInfo_Transform(kP3dLutActionInfo info);
kVsFx(kStatus) kP3dLutActionInfo_SetTransform(kP3dLutActionInfo info, const kL3dTransform2d* transform);

kVsFx(kBool)kP3dLutActionInfo_ExportLut(kP3dLutActionInfo info);
kVsFx(kStatus)kP3dLutActionInfo_SetExportLut(kP3dLutActionInfo info, kBool doExport);

#include <kVision/P3d/kP3dLutActionInfo.x.h>

#endif
