#ifndef LMITECH_KVISION_L3D_UTILITIES_H_INCLUDED
#define LMITECH_KVISION_L3D_UTILITIES_H_INCLUDED

#include <kFireSync/Client/kPipe.h>
#include <kFireSync/Client/kStorage.h>
#include <kFireSync/Client/kNode.h>
#include <kFireSync/Client/Camera/Extensions/kCameraDynExp.h>
#include <kVision/Common/kVision.h>
#include <kFireSync/Data/kDataTree.h>
#include <kApi/Data/kXml.h>
#include <kFireSync/Data/kHealthMsg.h>
#include <kFireSync/Utils/kSensorIdentity.h>
#include <kVision/L3d/kL3dCommon.h>

#if !defined(K_VIRTUAL)

kVsFx(kStatus) kL3dSensor_BackupFiles(kNode sensor, const kChar* folderName);
kVsFx(kStatus) kL3dSensor_ClearFiles(kNode sensor);

kVsFx(kStatus) kL3dSensor_ReadXml(kNode sensor, const kChar* fileName, kXml* xml);
kVsFx(kStatus) kL3dSensor_WriteXml(kNode sensor, const kChar* fileName, kXml xml);

kVsFx(kStatus) kL3dSensor_ReadIdentity(kNode device, kSensorIdentity* identity, kAlloc allocator);
kVsFx(kStatus) kL3dSensor_WriteIdentity(kNode device, kSensorIdentity identity, kBool isVolatile);

kVsFx(kStatus) kL3dSensor_AcquisitionPoint(kNode sensor, kPipe pipe, k32u cameraIndex, k32u stateIndex, kPort* port);
#endif /* !defined(K_VIRTUAL) */

kVsFx(kStatus) kL3dRect64f_Read(kRect64f* rect, kXml xml, kXmlItem item);
kVsFx(kStatus) kL3dRect64f_Write(const kRect64f* rect, kXml xml, kXmlItem item);

kVsFx(kStatus) kL3dCameraWindow_Read(kL3dCameraWindow* window, kXml xml, kXmlItem item);
kVsFx(kStatus) kL3dCameraWindow_Write(const kL3dCameraWindow* window, kXml xml, kXmlItem item);

kVsFx(kStatus) kL3dCameraDynExp_SaveDecTable(kCameraDynExp dynExp, kXml xml, kXmlItem item);

kVsFx(kStatus) kL3dRect3d64f_Write(const kRect3d64f* rect, kXml xml, kXmlItem item);
kVsFx(kStatus) kL3dRect3d64f_Read(kRect3d64f* rect, kXml xml, kXmlItem item);

kVsFx(kStatus) kL3dXml_MergeChild64f(kXml xml, kXmlItem item, const kChar* name, k64f* value);
kVsFx(kStatus) kL3dXml_MergeChildText(kXml xml, kXmlItem item, const kChar* name, kChar* str, kSize capacity);
kVsFx(kStatus) kL3dXml_MergeChild32u(kXml xml, kXmlItem item, const kChar* name, k32u* value);
kVsFx(kStatus) kL3dXml_MergeChild32s(kXml xml, kXmlItem item, const kChar* name, k32s* value);
kVsFx(kStatus) kL3dXml_MergeChildSize(kXml xml, kXmlItem item, const kChar* name, kSize* value);

kVsFx(kStatus) kL3dXml_SetItemBool(kXml xml, kXmlItem item, kBool value);
kVsFx(kStatus) kL3dXml_SetChildBool(kXml xml, kXmlItem item, const kChar* name, kBool value);

kVsFx(kStatus) kL3dXml_ItemBool(kXml xml, kXmlItem item, kBool* value);
kVsFx(kStatus) kL3dXml_ChildBool(kXml xml, kXmlItem item, const kChar* name, kBool* value);
kVsFx(kStatus) kL3dXml_MergeChildBool(kXml xml, kXmlItem item, const kChar* name, kBool* value);

kVsFx(kStatus) kL3dData_Save(kObject data, kObject node, const kChar* fileName);
kVsFx(kStatus) kL3dData_SaveCompressed(kObject data, kObject node, const kChar* fileName, kCompressionType algorithm, k32s level);
kVsFx(kStatus) kL3dData_Load(kObject* data, kObject node, const kChar* fileName);
kVsFx(kStatus) kL3dData_Replace(kObject* data, kObject source);

kVsFx(kStatus) kL3dString_Save(kString string, kObject node, const kChar* fileName);
kVsFx(kStatus) kL3dString_ReplaceSubstr(kString string, const kChar* subStr, const kChar* newStr);

kVsFx(const kChar*) kL3dAxisToString(k32u axis);

kVsFx(k32s) kL3dLog2i(k32s value);
kVsFx(k64f) kL3dPower64fi(k64f value, k32s power);

kVsFx(k64f) kL3dBilinearInterp64f(k64f v00, k64f v10, k64f v01,k64f v11, k64f xFract, k64f yFract);
kVsFx(k64f) kL3dTrilinearInterp64f(k64f a00, k64f a10, k64f a01,k64f a11,k64f b00, k64f b10, k64f b01,k64f b11, k64f xFract, k64f yFract, k64f zFract);

kVsFx(kStatus) kL3dImage_Pack(kImage in, kImage out, k8u mask);
kVsFx(kStatus) kL3dImage_FillOuter(kImage image, k32s x, k32s y, k32s width, k32s height, k8u value);
kVsFx(kStatus) kL3dImage_FillInner(kImage image, k32s x, k32s y, k32s width, k32s height, k8u value);

kVsFx(kStatus) kL3dArrayList_Reverse(kArrayList array);
kVsFx(kStatus) kL3dArray1_Reverse(kArray1 array);
kVsFx(kStatus) kL3dArray2_ReverseRows(kArray2 array);
kVsFx(kStatus) kL3dArray2_SliceColumn(kArray2 array, kSize column, kArray1 slice);
kVsFx(kStatus) kL3dArray2_Transpose(kArray2 array, kArray2 result);
kVsFx(kStatus) kL3dArray2_AverageRows(kArray2 array, kArray1 result);
kVsFx(kStatus) kL3dArray2_AverageColumns(kArray2 array, kArray1 result);
kVsFx(kStatus) kL3dArray2_SubRowAverage(kArray2 array, kArray2 result);
kVsFx(kStatus) kL3dArray2_SubColumnAverage(kArray2 array, kArray2 result);

kVsFx(kStatus) kL3dArray2_GenerateGrid(kArray2 xCoords,kArray2 yCoords, k64f xStart, k64f xEnd, k32u xCount, k64f yStart,k64f yEnd, k32u yCount);
kVsFx(kStatus) kL3dArray1_GenerateSteps(kArray1 steps, k64f start, k64f end, kSize count);
kVsFx(kStatus) kL3dArray1_FilterNull(kArray1 input, kArrayList output);

kVsFx(kStatus) kL3dValues64f_FindStepLocation(k64f* steps,kSize count, k64f position, k64f* index);
kVsFx(kStatus) kL3dPoints64f_FindBounds(kPoint64f* points, kSize count, kPoint64f* minBound, kPoint64f* maxBound);
kVsFx(kStatus) kL3dPoints3d16s_Clip(kPoint3d16s* points, kSize count, k16s minX, k16s maxX, k16s minY, k16s maxY, k16s minZ,k16s maxZ);
kVsFx(kStatus) kL3dPoints16s_Clip(kPoint16s* points,kSize count,k16s minX, k16s maxX, k16s minY, k16s maxY);
kVsFx(kStatus) kL3dValues16s_Clip(k16s* values, kSize count,k16s min,k16s max);

kVsFx(kStatus) kL3dCsv_Read32s(const kChar* text, k32s* values, kSize* count, kSize capacity);

kVsFx(kStatus) kL3dCsv_Write32s(const k32s* values, kSize count, kChar* text, kSize capacity);
kVsFx(kStatus) kL3dCsv_Read32u(const kChar* text, k32u* values, kSize* count, kSize capacity);

kVsFx(kStatus) kL3dCsv_WriteSize(const kSize* values, kSize count, kChar* text, kSize capacity);
kVsFx(kStatus) kL3dCsv_ReadSize(const kChar* text, kSize* values, kSize* count, kSize capacity);


kVsFx(kStatus) kL3dCsv_Write32u(const k32u* values, kSize count, kChar* text, kSize capacity);
kVsFx(kStatus) kL3dCsv_Read64f(const kChar* text, k64f* values, kSize* count, kSize capacity);
kVsFx(kStatus) kL3dCsv_Write64f(const k64f * values, kSize count, kChar* text, kSize capacity);
kVsFx(kStatus) kL3dCsv_ReadText32(const kChar* text, kText32* values, kSize* count, kSize capacity);
kVsFx(kStatus) kL3dCsv_WriteText32(const kText32 * values, kSize count, kChar* text, kSize capacity);

kVsFx(kStatus) kL3dText_ToLower(const kChar* input, kChar* output, kSize capacity);
kVsFx(kStatus) kL3dFile_Get(kObject node, const kChar* fileName, kBool read, kStream* stream);

kVsFx(k64s)    kL3dHealthMsg_GetStatById(kHealthMsg msg, kHealthId id);

kVsFx(kStatus) kL3dVer_ComputeLinearTrend(k64f* xValues, k64f* yValues, k32u count, k64f* yIntercept, k64f* slope);

#endif      /* #ifndef LMITECH_KVISION_L3D_UTILITIES_H_INCLUDED */
