#ifndef LMITECH_KVISION_L3D_SYSTEMALIGNBAR_H_INCLUDED
#define LMITECH_KVISION_L3D_SYSTEMALIGNBAR_H_INCLUDED

//#include <kVision/L3d/kL3dCommon.h>
//#include <kFireSync/Data/kPlot.h>
#include <kVision/L3d/kL3dTransform3d.h>
#include <kVision/Vs/kVsDef.h>

typedef enum
{
    BAR_CAL_STATE_LEVELING,
    BAR_CAL_STATE_SEARCHING,
    BAR_CAL_STATE_SCANNING,
    BAR_CAL_STATE_COMPLETE,
    BAR_CAL_STATE_NO_BAR,
    BAR_CAL_STATE_NO_SLOT,
    BAR_CAL_STATE_ENCODER_ERROR
} kL3dBarCalState;

/**
* @class       kL3dSystemAlignBar
* @extends     kObject
* @ingroup     kVision-L3d
* @brief       Class object for the kL3dSystemAlignBar class.
*/
typedef kObject kL3dSystemAlignBar;


/**
* Constructs a kP3dSystemAlignBar object.
*
* @public               @memberof kL3dSystemAlignBar
* @param   object       Destination for the constructed object handle.
* @param   alloc        Memory allocator (or kNULL for default).
* @return               Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_Construct(kL3dSystemAlignBar* object, kAlloc alloc);

/**
* Destroys a kP3dSystemAlignBar object.
*
* @public               @memberof kL3dSystemAlignBar
* @param   object       Destination for the constructed object handle.
* @return               Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_Destroy(kL3dSystemAlignBar object);

/**
* Runs the calibration.  Requires that the initial parameters.
*
* @public               @memberof kL3dSystemAlignBar
* @param   object       kL3dSystemAlignBar class
* @param   surface      Height map points
* @param   alloc        Allocator
* @return               Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_Run(kL3dSystemAlignBar object, kArray2 heightmap, kPoint3d64f resolution, k64s encoderY, k64f xOffset, kAlloc alloc);


/**
* Sets all the information to be either 0 or null and sets the state to be leveling.
* If you want to process multiple height maps, this must be called between each successive call to startSurface.  
*
* @public               @memberof kL3dSystemAlignBar
* @param   object       The kL3dSystemAlignBar object handle.
* @return               Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_Reset(kL3dSystemAlignBar object);

/**
* Called after StartSurface.  This performs the calculations.  Also creates a plot object describing the results.
* 
* @public               @memberof kL3dSystemAlignBar
* @param   object       The kL3dSystemAlignBar object handle.
* @return               A kL3dBarCalState (this indicates if the calculation succeeded.  If it does not succeed, it indicates why).
*/
kVsFx(kL3dBarCalState) kL3dSystemAlignBar_Result(kL3dSystemAlignBar object);

/**
* Performs a transform on the surface.  If transform is null, performs the calculated tranform.
*
* @public               @memberof kL3dSystemAlignBar
* @param   object       The kL3dSystemAlignBar object handle.
* @param   kArray2      The surface to transform
* @param   kArray2      The surface to put the resulting data.  Must be already initialized.  Can be the same as source surface.
* @param   kL3dTransform3d  The transform to apply.  If it is null, it will use the calculated result from calibration.
* @return               Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_TransformSurface(kArray2 sourceSurface, kArray2 destinationSurface, const kL3dTransform3d *transform);



//Input parameters
/**
* The width of the bar, in mm.
* 
* @public               @memberof kL3dSystemAlignBar - Input parameter
* @param   object       The kL3dSystemAlignBar object handle.
* @param   barWidth     Input parameter - bar width
* @return               Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_SetBarWidth(kL3dSystemAlignBar object, k64f barWidth);

/**
* This is used to set the hole spacing on the calibration bar.  Each sensor should only see a single hole.  In mm.
*
* @public               @memberof kL3dSystemAlignBar - Input parameter
* @param   object       The kL3dSystemAlignBar object handle.
* @param   barWidth     Input parameter - The spacing between the holes.  This is used to translate all the sensors into the same coordinate system.
* @return               Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_SetSlotSpacing(kL3dSystemAlignBar object, k64f slotSpacing);

/**
* This is used to set the hole seen by this sensor.  Used to set the position of each sensor to be relative to the first hole.  Each sensor should only be able to see one hole.
* Indexed from 0.
*
* @public               @memberof kL3dSystemAlignBar - Input parameter
* @param   object       The kL3dSystemAlignBar object handle.
* @param   barWidth     Input parameter - The slot which is seen by this sensor.
* @return               Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_SetSlotSeen(kL3dSystemAlignBar object, k32u slotSeen);

/**
* The threshold to for considering a depth measurement as being on the bar.
*
* @public                   @memberof kL3dSystemAlignBar - Input parameter
* @param   object           The kL3dSystemAlignBar object handle.
* @param   depthThreshold   Input parameter - depth threshold
* @return                   Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_SetDepthThreshold(kL3dSystemAlignBar object, k64f depthThreshold);

/**
* @public                   @memberof kL3dSystemAlignBar - Input parameter
* @param   object           The kL3dSystemAlignBar object handle.
* @param   slotThreshold    Input parameter - spot threshold
* @return                   Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_SetSlotThreshold(kL3dSystemAlignBar object, k64f slotThreshold);

/**
* @public                   @memberof kL3dSystemAlignBar - Input parameter
* @param   object           The kL3dSystemAlignBar object handle.
* @param   sourceTransform  Input parameter - source transform
* @return                   Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_SetSourceTransform(kL3dSystemAlignBar object, kL3dTransform3d sourceTransform);

/**
* @public                   @memberof kL3dSystemAlignBar - Input parameter - Currently the only reference type supported is the reference bar.
* @param   object           The kL3dSystemAlignBar object handle.
* @param   referenceType    Input parameter - Reference type
* @return                   Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_SetReferenceType(kL3dSystemAlignBar object, kVsSystemCalibrationReferenceType referenceType);

/**
* The level sample count is the number of samples being observed to calculate the background level.  Also the minimum number of samples for the bar.
* Also, the minimum depth of the hole before it is detected.  
* 
* @public                     @memberof kL3dSystemAlignBar - Input parameter
* @param   object             The kL3dSystemAlignBar object handle.
* @param   levelSampleCount   Input parameter - Reference position
* @return                     Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_SetLevelSampleCount(kL3dSystemAlignBar object, k32u levelSampleCount);

/**
* Optional input.  The edge sample count is the number of samples being observed to find the edges.  Default is 5.
*
* @public                     @memberof kL3dSystemAlignBar - Input parameter
* @param   object             The kL3dSystemAlignBar object handle.
* @param   edgeSampleCount    Input parameter - Reference position
* @return                     Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_SetEdgeThreshold(kL3dSystemAlignBar object, k64f edgeThreshold);


/**
* Optional input.  Determines if the sampling is encoder based or not.  Default is true.
*
* @public                     @memberof kL3dSystemAlignBar - Input parameter
* @param   object             The kL3dSystemAlignBar object handle.
* @param   referencePosition  Input parameter - Reference position
* @return                     Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_SetEncoderBased(kL3dSystemAlignBar object, kBool encoderBased);

/**
* Input.  Sets the resolution of the encoder.
*
* @public                     @memberof kL3dSystemAlignBar - Input parameter
* @param   object             The kL3dSystemAlignBar object handle.
* @param   encoderResolution  The encoder resolution in mm per tick.
* @return                     Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_SetEncoderResolution(kL3dSystemAlignBar object, k64f encoderResolution);

//Outputs
/**
* @public                     @memberof kL3dSystemAlignBar
* @param   object             The kL3dSystemAlignBar object handle.
* @return                     The align transform.
*/
kVsFx(kL3dTransform3d) kL3dSystemAlignBar_AlignTransformResult(kL3dSystemAlignBar object);

/**
* Returns the current state of the processing.
*
* @public                     @memberof kL3dSystemAlignBar
* @param   object             The kL3dSystemAlignBar object handle.
* @return                     Travel speed result
*/
kVsFx(kL3dBarCalState) kL3dSystemAlignBar_State(kL3dSystemAlignBar object);


//These functions allow you to get the input parameters.  I am not sure if they are useful though.
/**
* Returns the source transform.  If this has not been set, the transform will be the identity transform.
*
* @public                     @memberof kL3dSystemAlignBar
* @param   object             The kL3dSystemAlignBar object handle.
* @return                     Travel speed result
*/
kL3dTransform3d kL3dSystemAlignBar_SourceTransform(kL3dSystemAlignBar object);

/**
* Creates the inverse transform from the forward transform.
*
* @public                     @memberof kL3dSurfaceCombiner
* @param   forwardTransform   The forward transform.
* @param   reverseTransform   The location of the kL3dTransform3d structure to hold the reverse transform.
* @return                     Operation status.
*/
kVsFx(kStatus) kL3dSystemAlignBar_ReverseTransform(kL3dTransform3d forwardTransform, kL3dTransform3d *reverseTransform);


/**
* Returns the rotation around the y axis.  
*
* @public                     @memberof kL3dSurfaceCombiner
* @param  object              The class object.
* @return                     rotation around the y axis.
*/
kVsFx(k64f) kL3dSystemAlignBar_RotationAroundY(kL3dSystemAlignBar object);

/**
* Returns the rotation around the z axis.
*
* @public                     @memberof kL3dSurfaceCombiner
* @param  object              The class object.
* @return                     rotation around the z axis.
*/
kVsFx(k64f) kL3dSystemAlignBar_RotationAroundZ(kL3dSystemAlignBar object);

/**
* Returns all the rotations as a kPoint3d64f structure.  The x value is the rotations around x, the y value is the rotation around y, and the z value is the rotation around z.
*
* @public                     @memberof kL3dSurfaceCombiner
* @param  object              The class object.
* @return                     The rotations.
*/
kVsFx(kPoint3d64f) kL3dSystemAlignBar_Rotations(kL3dSystemAlignBar object);

/**
* Returns the x,y, and z offsets.
*
* @public                     @memberof kL3dSurfaceCombiner
* @param  object              The class object.
* @return                     A point3d that has the x,y, and z offsets.
*/
kVsFx(kPoint3d64f) kL3dSystemAlignBar_Translations(kL3dSystemAlignBar object);

/**
* Returns the angle of the bar from the x axis.
*
* @public                     @memberof kL3dSurfaceCombiner
* @param  object              The class object.
* @return                     The position of the first hole.
*/
kVsFx(k64f) kL3dSystemAlignBar_BarAngle(kL3dSystemAlignBar object);

/**
* Returns the calculated width of the bar.  Note, if the bar is not 90 degrees to the direction of motion, this will be greater than the actual bar width.
*
* @public                     @memberof kL3dSurfaceCombiner
* @param  object              The class object.
* @return                     The position of the first hole.
*/
kVsFx(k64f) kL3dSystemAlignBar_ApparentBarWidth(kL3dSystemAlignBar object);

#include <kVision/L3d/kL3dSystemAlignBar.x.h>

#endif
