/**
* @file    kL3dLvdsImageErrorsBlockInfo.x.h
* @brief   Declares the kL3dLvdsImageErrorsBlockInfo class.
*
* @internal
* Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
*/
#ifndef L3D_LVDS_IMAGE_ERRORS_BLOCK_INFO_X_H_INCLUDED
#define L3D_LVDS_IMAGE_ERRORS_BLOCK_INFO_X_H_INCLUDED

#include <kApi/Data/kXml.h>

typedef struct kL3dLvdsImageErrorsBlockInfoClass
{
    kObjectClass base;

    kSize noiseTolerance;/* How much a pixel must change by for it to be considered different.  Changes below this are considered background noise.*/

    kSize pixelTolerance;
    kSize sumTolerance;

} kL3dLvdsImageErrorsBlockInfoClass;

kDeclareClassEx(kVs, kL3dLvdsImageErrorsBlockInfo, kObject)

kVsFx(kStatus) kL3dLvdsImageErrorsBlockInfo_Init(kL3dLvdsImageErrorsBlockInfo info, kType type, kAlloc alloc);
kVsFx(kStatus) kL3dLvdsImageErrorsBlockInfo_VRelease(kL3dLvdsImageErrorsBlockInfo info);
kVsFx(kStatus) kL3dLvdsImageErrorsBlockInfo_Write(kL3dLvdsImageErrorsBlockInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kL3dLvdsImageErrorsBlockInfo_Read(kL3dLvdsImageErrorsBlockInfo info, kXml xml, kXmlItem item);

#endif
