#ifndef LMITECH_KVISION_L3D_XCALDATA_H_INCLUDED
#define LMITECH_KVISION_L3D_XCALDATA_H_INCLUDED

#include <kVision/L3d/kL3dCalData.h>

typedef struct kL3dCalDataClass 
{
    kObjectClass base;
} kL3dCalDataClass;

typedef struct kL3dCalDataVTable
{
    kObjectVTable base;

    kStatus(kCall* VStore)(kL3dCalData data, kDataTree tree, kDataTreeItem item);
    kStatus(kCall* VAssign)(kL3dCalData data, kL3dCalData source);
    kL3dCalDataType(kCall* VType)(kL3dCalData data);
} kL3dCalDataVTable;

kDeclareVirtualClassEx(kVs, kL3dCalData, kObject);

kVsFx(kStatus) kL3dCalData_Init(kL3dCalData data, kType type, kAlloc allocator);

kVsFx(kStatus) kL3dCalData_VRelease(kL3dCalData data);

kVsFx(kStatus) kL3dCalData_VStore(kL3dCalData data, kDataTree tree, kDataTreeItem item);
kVsFx(kStatus) kL3dCalData_VAssign(kL3dCalData data, kL3dCalData source);
kVsFx(kL3dCalDataType) kL3dCalData_VType(kL3dCalData data);

#endif /* #ifndef LMITECH_KVISION_L3D_XCALDATA_H_INCLUDED */
