/**
* @file    kG3dContourSegment.x.h
* @brief   
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_kG3D_CONTOURSEGMENT_X_H
#define KVISION_kG3D_CONTOURSEGMENT_X_H

#define kG3DCOUNTOURSEGMENT_DEFAULT_SEARCH_WIDTH      5
#define kG3DCOUNTOURSEGMENT_MINIMUM_POINTCOUNT        100
#define kG3DCOUNTOURSEGMENT_MINIMUM_SECTIONPOINT      20
#define kG3DCOUNTOURSEGMENT_BOARD_DEFAULT_WIDTH       8
#define kG3DCOUNTOURSEGMENT_DEFAULT_ANGLE_TOLERANCE   15
#define kG3D_CONTOURSEGMENT_BORDER_INDEX              1

typedef struct kG3dIndexContourType
{
    kArray1 curve;
    k32s curveIndex;
    k32s pointCount;
    kBool isClosed;
}kG3dIndexContourType;

typedef struct kS3dContourSortItem
{
    k32s startPosIndex;
    k32s endPosIndex;
    k32s startCurveIndex;
    k32s endCurveIndex;
    k32s pointCount;
    kBool valid;
}kS3dContourSortItem;

typedef struct kG3dContourSegmentClass
{
    kObjectClass base;

    kArray2 value;
    kArray2 angle;
    kArray2 maskMap;

    kArray2 segMap;
    kArray2 tempMap;
    kArray2 countMap;
    kArray1 cosTab;
    kArray1 maskBuffer;
    kArray1 borderPoints;
    kArray1 contourPoints;

    k32s pointsCount;
    k32s poitionIndex;
    k32s pointCount;
    k32s pointIndex;

    k32s curveCount;
    k32s curveIndex;

    k32s imageSizeX;
    k32s imageSizeY;

    k32s angleCount;
    kG3dIndexContourType countItem;
    kS3dContourSortItem item;
    kBool success;
    k32s angleTol;
    k32s angleMax;
    k32s repeat;
    k32s offset;
    k32s threshold;
    k32s mode;
    kBool areaSegmentUsed;
    kBool mainSegmentUsed;

    k32s sampleIndex;
    k32s repeatIndex;

    kBool detectBorder;
    kBool detectClosedContour;
} kG3dContourSegmentClass;

kDeclareClassEx(kVs, kG3dContourSegment, kObject)

kStatus kG3dContourSegment_Init(kG3dContourSegment segment, kType classType, kAlloc alloc);

kVsFx(kStatus) kG3dContourSegment_VInitClone(kG3dContourSegment segment, kG3dContourSegment source, kAlloc allocator);
kVsFx(kSize)   kG3dContourSegment_VSize(kG3dContourSegment segment);
kVsFx(kStatus) kG3dContourSegment_VRelease(kG3dContourSegment segment);
kStatus kG3dContourSegment_ReleaseBuffer(kG3dContourSegment segment);

kVsFx(kStatus) kG3dContourSegment_Run(kG3dContourSegment segment, kArray1* contourPoints, kArray2 value, kArray2 angle, k32s mode);
kVsFx(kStatus) kG3dContourSegment_SetAngleCount(kG3dContourSegment segment, kSize count);
kVsFx(kStatus) kG3dContourSegment_SetThreshold(kG3dContourSegment segment, kSize threshold);

kStatus kG3dContourSegment_Setup(kG3dContourSegment segment);
kStatus kG3dContourSegment_SegmentAfterAngle(kG3dContourSegment segment);
kStatus kG3dContourSegment_FillTopLeftThread(kG3dContourSegment segment, kSize startRow, kSize rowCount);
kStatus kG3dContourSegment_FillBottomRightThread(kG3dContourSegment segment, kSize startRow, kSize rowCount);
kStatus kG3dContourSegment_FillBottomLeftThread(kG3dContourSegment  segment, kSize startRow, kSize rowCount);
kStatus kG3dContourSegment_FillTopRightThread(kG3dContourSegment  segment, kSize startRow, kSize rowCount);
kStatus kG3dContourSegment_CreateContourPoints(kG3dContourSegment segment);
kStatus kG3dContourSegment_FillTempTopLeftThread(kG3dContourSegment segment, kSize startRow, kSize rowCount);
kStatus kG3dContourSegment_FillTempBottomRightThread(kG3dContourSegment segment, kSize startRow, kSize rowCount);
kStatus kG3dContourSegment_FillTempBottomLeftThread(kG3dContourSegment  segment, kSize startRow, kSize rowCount);
kStatus kG3dContourSegment_FillTempTopRightThread(kG3dContourSegment  segment, kSize startRow, kSize rowCount);
kStatus kG3dContourSegment_MainBodyDetection(kG3dContourSegment segment);
kStatus kG3dContourSegment_Expand(kG3dContourSegment segment);
kStatus kG3dContourSegment_ShrinkContour(kG3dContourSegment segment);
kStatus kG3dContourSegment_PointDirection(kG3dContourSegment segment);
kStatus kG3dContourSegment_EliminateInvalid(kG3dContourSegment segment);
kStatus kG3dContourSegment_CreateBorderPoints(kG3dContourSegment segment);
kStatus kG3dContourSegment_MarkBorderPoints(kG3dContourSegment segment);
kStatus kG3dContourSegment_FillSegment(kG3dContourSegment segment);

#endif  /* KVISION_kG3D_CONTOURSEGMENT_X_H */
