/**
* @file    kG3dContourMatching.x.h
* @brief   
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_kG3D_CONTOURMATCHING_X_H
#define KVISION_kG3D_CONTOURMATCHING_X_H

typedef struct kG3dContourMatchingClass
{
    kObjectClass base;

    kArray2 inputHeightMap;
    kArray2 inputIntensityMap;
    kArray2 inputTextureMap;
    kImage inputTextureImg;
    kArray2 inputHeightMap2;
    kArray2 inputIntensityMap2;

    kArray2 worldHeightMap;
    kArray2 worldMaskMap;

    kArray2 outputHeightMap;
    kArray2 outputMaskMap;
    kArray2 outputDifference;
    kArray2 outputIntensityMap2;
    kArray2 outputBitmap;
    kImage  worldMaskImg;
    kArrayList correlationXYPoints;
    kArrayList correlationXYDiff;
    kArrayList correlationZPoints;
    kArrayList correlationOutputZ;
    kG3dPalette palette;

    kPoint3d64f scale;
    kPoint3d64f offset;
    kPoint3d64f scale2;
    kPoint3d64f offset2;

    kPoint3d64f bmpScale;
    kG3dContourTemplate mask;
    kG3dSegmentPlanes plans;
    kG3dAffineMergeHeightMap merge;
    kG3dJumpContour jumpCountur;
    kBool isBmp;
    k32s imageSizeX;
    k32s imageSizeY;
    k32s mode;
    kBool flipHeightMap;
    kBool flipBitmap;
    kArray1 tempLine;
    kBool transformHeightmap;
    kBool transformBitmap;
    kBool transformMaskMap;
    kBool transformBuddyIntensity;
    k64s totalTime;
    k32s sampleIndex;
    k32s repeatIndex;
    kBool saveTemplate;
    kText256 templateFileName;
    kTimer timer;
    k32s worldImgSizeX;
    k32s worldImgSizeY;
    k64f zmax;
    k64f zmin;
    kBool ownMask;

    kChar* diffFileName;
    kChar* textureBmpName;
    kChar* mainIntensityName;
    kChar* buddyIntensityName;
    kChar* overflowBmpName;
    kChar* heightBmpName;
    kChar* heightmapOutName;
    kChar* heightAlignOutName;

    kBool diffFileUsed;
    kBool textureBmpUsed;
    kBool mainIntensityUsed;
    kBool buddyIntensityUsed;
    kBool overflowBmpUsed;
    kBool heightBmpUsed;
    kBool heightmapOutUsed;
    kBool heightAlignOutUsed;
} kG3dContourMatchingClass;

kDeclareClassEx(kVs, kG3dContourMatching, kObject)

kStatus kG3dContourMatching_Init(kG3dContourMatching matching, kType classType, kAlloc alloc);

kVsFx(kStatus) kG3dContourMatching_VInitClone(kG3dContourMatching matching, kG3dContourMatching source, kAlloc allocator);
kVsFx(kSize)   kG3dContourMatching_VSize(kG3dContourMatching matching);
kVsFx(kStatus) kG3dContourMatching_VRelease(kG3dContourMatching matching);

kVsFx(kStatus) kG3dContourMatching_Run(kG3dContourMatching matching, kArray2 heightMap, kArray2 textureMap, kArray2 intensityMap);
kStatus kG3dContourMatching_Setup(kG3dContourMatching matching);
kStatus kG3dContourMatching_CalculateTextureEdgeCountour(kG3dContourMatching matching);
kStatus kG3dContourMatching_SearchTemplateEdgeCountour(kG3dContourMatching matching);
kStatus kG3dContourMatching_MergeHeightMap(kG3dContourMatching matching);
kStatus kG3dContourMatching_CalculateOffsetPlans(kG3dContourMatching matching);
kStatus kG3dContourMatching_FlipMaps(kG3dContourMatching matching, kBool back);
kStatus kG3dContourMatching_FlipHeightMap(kG3dContourMatching matching, kArray2 map);
kStatus kG3dContourMatching_FlipIntensityMap(kG3dContourMatching matching, kArray2 map);
kStatus kG3dContourMatching_StartTimer(kG3dContourMatching matching);
k64s kG3dContourMatching_ElapsedTime(kG3dContourMatching matching);
kStatus kG3dContourMatching_EvaluateHeightMaps(kG3dContourMatching matching);
kStatus kG3dContourMatching_CalculatePointsHeight(kG3dContourMatching matching);
kStatus kG3dContourMatching_DrawMaskBitmap(kG3dContourMatching matching);
kStatus kG3dContourMatching_DrawTextureBitmap(kG3dContourMatching matching, k32s mode);
kStatus kG3dContourMatching_DrawHeightBitmap(kG3dContourMatching matching);
kStatus kG3dContourMatching_DrawPoints(kG3dContourMatching matching, kImage image);

#endif  /* KVISION_kG3D_CONTOURMATCHING_X_H */
