#ifndef LMITECH_KPOLYNOMIALFIT_H_INCLUDED
#define LMITECH_KPOLYNOMIALFIT_H_INCLUDED

#include <kVision/Common/kPolynomial.h>

typedef kObject kPolynomialFit; 

kVsFx(kStatus) kPolynomialFit_Construct(kPolynomialFit* fit, k32s maxOrder, kObject allocator); 

kVsFx(kStatus) kPolynomialFit_Apply(kPolynomialFit fit, const k64f* x, const k64f* f, kSize count, kPolynomial function);
kVsFx(kStatus) kPolynomialFit_SetOrderPenalty(kPolynomialFit fit, k64f orderPenalty);
kVsFx(kStatus) kPolynomialFit_SetTargetError(kPolynomialFit fit, k64f targetError);

kVsFx(k32s) kPolynomialFit_Order(kPolynomialFit fit); 
kVsFx(k64f) kPolynomialFit_OrderPenalty(kPolynomialFit fit); 
kVsFx(k64f) kPolynomialFit_TargetError(kPolynomialFit fit); 
 
#define kPOLYNOMIAL_FIT_ORDER(FIT)              kxPOLYNOMIAL_FIT_ORDER(FIT)
#define kPOLYNOMIAL_FIT_ORDER_PENALTY(FIT)      kxPOLYNOMIAL_FIT_ORDER_PENALTY(FIT)
#define kPOLYNOMIAL_FIT_TARGET_ERROR(FIT)       kxPOLYNOMIAL_FIT_TARGET_ERROR(FIT)

#include <kVision/Common/kPolynomialFit.x.h>

#endif
