/** 
 * @file    kFsDef.x.h
 *
 * @internal
 * Copyright (C) 2012-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_FIRESYNC_DEF_X_H
#define K_FIRESYNC_FIRESYNC_DEF_X_H

//microseconds from Jan 1, 1 CE to start of FireSync 7 era (Jan 1, 2019) 
#define xkFIRESYNC_7_EPOCH              (0x00E23E5935122000)

kDeclareValueEx(kFs, kPair32s, kValue)

kDeclareEnumEx(kFs, kEthernetLink, kValue)

//transition functions; the kNetworkSpeed enum will eventually be removed
kFsFx(kNetworkSpeed) kEthernetLink_ToNetworkSpeed(kEthernetLink speed); 
kFsFx(kEthernetLink) kEthernetLink_FromNetworkSpeed(kNetworkSpeed speed); 

/**
 * @struct  kEthernetFlowControl
 * @extends kValue
 * @ingroup kFireSync
 * @brief   Represents an Ethernet flow control option. 
 */
typedef k32s kEthernetFlowControl; 

/** @relates kEthernetLink @{ */
#define kETHERNET_FLOW_CONTROL_NONE             (0)        ///< No flow control.
#define kETHERNET_FLOW_CONTROL_BOTH             (1)        ///< Bi-directional flow control (send/receive pause frames).
#define kETHERNET_FLOW_CONTROL_RX               (2)        ///< Flow control on inbound traffic (send pause frames).
#define kETHERNET_FLOW_CONTROL_TX               (3)        ///< Flow control on outbound traffic (accept pause frames).
/** @} */


kDeclareEnumEx(kFs, kNetworkSpeed, kValue)
kDeclareEnumEx(kFs, kAlignment, kValue)
kDeclareEnumEx(kFs, kIpNegotiation, kValue)

#define kIP_NEGOTIATION_DHCP_ZERO_CONF          (2)             //Legacy; do not use; now interpretted same as kIP_NEGOTIATION_DHCP by drivers.

kDeclareValueEx(kFs, kIpConfig, kValue)

kDeclareValueEx(kFs, kRegisterBits, kValue)

kFsFx(kStatus) kRegisterBits_Write(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kRegisterBits_Read(kType type, void* values, kSize count, kSerializer serializer);

kDeclareValueEx(kFs, kRegister16u, kValue)

kFsFx(kStatus) kRegister16u_Write(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kRegister16u_Read(kType type, void* values, kSize count, kSerializer serializer);

kDeclareValueEx(kFs, kRegister32u, kValue)

kDeclareValueEx(kFs, kRegisterInfo32u, kValue)

kFsFx(kStatus) kRegisterInfo32u_Write(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kRegisterInfo32u_Read(kType type, void* values, kSize count, kSerializer serializer);

kDeclareValueEx(kFs, kRegisterOverride32u, kValue)

kFsFx(kStatus) kRegisterOverride32u_Write(kType type, void* values, kSize count, kSerializer serializer);
kFsFx(kStatus) kRegisterOverride32u_Read(kType type, void* values, kSize count, kSerializer serializer);

kDeclareEnumEx(kFs, kDemosaicStyle, kValue)

kDeclareEnumEx(kFs, kAxis, kValue)

kDeclareEnumEx(kFs, kCompressedPhaseStreamId, kValue)

#define kCOMPRESSED_PHASE_MAX_STREAM_ID                 (7)        //Maximum defined stream id. 

kInlineFx(kBool) kCompressedPhaseStreamId_IsValid(kCompressedPhaseStreamId id)
{
    return (id >= 0) && (id < kCOMPRESSED_PHASE_MAX_STREAM_ID);
}

kDeclareEnumEx(kFs, kCompressedPhaseEncoding, kValue)

kFsFx(kSize) xkCompressedPhaseEncoding_GlobalMaxItemsPerPackedWordSet();
kFsFx(kSize) xkCompressedPhaseEncoding_MaxItemsPerPackedWordSet(kCompressedPhaseEncoding encoding);
kFsFx(kSize) xkCompressedPhaseEncoding_WordSetSize(kCompressedPhaseEncoding encoding);

#define xkMax3_(x,y,z) ((x) > (y) ? kMax_(x,z) : kMax_(y,z))
#define xkMin3_(x,y,z) ((x) > (y) ? kMin_(y,z) : kMin_(x,z))

//forward declarations
typedef kObject kAction;
typedef kObject kActions;
typedef kObject kAlgInfo;
typedef kObject kAnalogOut;
typedef kObject kArchive;
typedef kObject kArp;
typedef kObject kAxAction;
typedef kObject kAxEnviron;
typedef kObject kBinCSum4Alg;
typedef kObject kBinCSum4BlockInfo;
typedef kObject kBlock;
typedef kObject kCamera;
typedef kObject kCameraInfo;
typedef kObject kCameraExt; 
typedef kObject kCameraState;
typedef kObject kCompressedPhase;
typedef kObject kCompressedPhaseReader;
typedef kObject kCompressedPhaseStream;
typedef kObject kControl5Client;
typedef kObject kControl6Client;
typedef kObject kCrc32;
typedef kObject kCSum4Alg;
typedef kObject kCudaAlloc;
typedef kObject kCudaDevice; 
typedef kObject kCudaDeviceAlloc; 
typedef kObject kCudaManagedAlloc; 
typedef kObject kCudaPinnedAlloc; 
typedef kObject kCudaStream; 
typedef kObject kData6Client;
typedef kObject kDataTree;
typedef kObject kDataTreeItem;
typedef kObject kDhcpClient;
typedef kObject kDhcpServer;
typedef kObject kDigitalOut;
typedef kObject kDiscovery5Client;
typedef kObject kDiscovery6Client;
typedef kObject kDiscoveryProvider;
typedef kObject kEncoder;
typedef kObject kEventManager;
typedef kObject kGpioBank;
typedef kObject kGraphic;
typedef kObject kForwardBlockInfo;
typedef kObject kHealth;
typedef kObject kHealth6Client;
typedef kObject kHealthLog;
typedef kObject kHealthLogManifest;
typedef kObject kHealthLogSnapshot;
typedef kObject kHealthLogSnapshotManager;
typedef kObject kHealthLogSnapshotBlock;
typedef kObject kHealthMsg;
typedef kObject kHealthProbe;
typedef kObject kHealthSummary;
typedef kObject kHealthSummaryStat;
typedef kObject kHeapAlloc;
typedef kObject kHxAnalogOut;
typedef kObject kHxCamera;
typedef kObject kHxCameraState;
typedef kObject kHxCameraExt;
typedef kObject kHxDigitalOut;
typedef kObject kHxEncoder;
typedef kObject kHxEvent;
typedef kObject kHxGpio;
typedef kObject kHxIoTest;
typedef kObject kHxLight;
typedef kObject kHxLightState;
typedef kObject kHxLightExt;
typedef kObject kHxNode;
typedef kObject kHxProjector;
typedef kObject kHxProjectorState;
typedef kObject kHxProjectorExt;
typedef kObject kHxSerialOut;
typedef kObject kHxTestJig;
typedef kObject kInvertAlg;
typedef kObject kInvertBlockInfo;
typedef kObject kIoTest;
typedef kObject kLc250xFpnBlockInfo;
typedef kObject kLdCal;
typedef kObject kLdCalLookup;
typedef kObject kLdModel;
typedef kObject kLight;
typedef kObject kLightExt;
typedef kObject kLightState;
typedef kObject kMemoryDomainBlockInfo;
typedef kObject kMemoryTrafficActionInfo;
typedef kObject kMemoryTrafficBlockInfo;
typedef kObject kMemoryTrafficWorker;
typedef kObject kMovingAvg;
typedef kObject kMsg;
typedef kObject kMsgInfo; 
typedef kObject kMsgSet;
typedef kObject kNet;
typedef kObject kNetInterface;
typedef kObject kNode;
typedef kObject kNode5Client;
typedef kObject kNode6Client;
typedef kObject kNodeProvider;
typedef kObject kOrientation;
typedef kObject kPacketSocket;
typedef kObject kPacketSocketPacket;
typedef kObject kPageCache;
typedef kObject kPort;
typedef kObject kPipe; 
typedef kObject kPlot;
typedef kObject kProfileProbe;
typedef kObject kProjector;
typedef kObject kProjectorInfo;
typedef kObject kProjectorExt;
typedef kObject kProjectorState;
typedef kObject kPropertyList;
typedef kObject kRoute;
typedef kObject kPxBlock;
typedef kObject kPxEnviron;
typedef kObject kPxPort;
typedef kObject kPxPipe;
typedef kHash kSha256Hash;
typedef kObject kSensorIdentity;
typedef kObject kStartActionInfo;
typedef kObject kSerialOut;
typedef kObject kSpline;
typedef kObject kStorage;
typedef kObject kStorageItem;
typedef kObject kSvActions; 
typedef kObject kSvAnalogOut;
typedef kObject kSvCamera;
typedef kObject kSvControl;
typedef kObject kSvControlChannel; 
typedef kObject kSvDataIn;
typedef kObject kSvDataInChannel;
typedef kObject kSvDataOut;
typedef kObject kSvDataOutChannel;
typedef kObject kSvDigitalOut;
typedef kObject kSvDiscovery; 
typedef kObject kSvDiscoveryProvider; 
typedef kObject kSvEncoder;
typedef kObject kSvEventManager;
typedef kObject kSvHealthOut;
typedef kObject kSvHealthOutChannel;
typedef kObject kSvIoTest;
typedef kObject kSvLight;
typedef kObject kSvNode; 
typedef kObject kSvNodeProvider; 
typedef kObject kSvProjector; 
typedef kObject kSvPipe; 
typedef kObject kSvSerialOut; 
typedef kObject kSvTestJig;
typedef kObject kSvWeb;
typedef kObject kSystem;
typedef kObject kTar;
typedef kObject kTempControl;
typedef kObject kTerrain;
typedef kObject kTerrainModel;
typedef kObject kTestJig;
typedef kObject kTimeAvg;
typedef kObject kTimerBlockInfo;
typedef kObject kUnpackedCompressedPhase;

typedef kAxAction kCameraCalibrationAction;
typedef kAxAction kLvdsEyeAction; 
typedef kAxAction kLvdsSetDelayAction; 
typedef kAxAction kMemoryTrafficAction;
typedef kAxAction kStartAction; 

typedef kAlgInfo kAcgInfo; 
typedef kAlgInfo kAccgd2kInfo;
typedef kAlgInfo kBinCSum4Info; 
typedef kAlgInfo kSobelwArcgdwInfo; 
typedef kAlgInfo kSobelvAccgdwInfo; 

typedef kCameraInfo kLc150Info;
typedef kCameraInfo kLc65xInfo;
typedef kCameraInfo kLc130xInfo;
typedef kCameraInfo kLc200xInfo;
typedef kCameraInfo kLc250xInfo;
typedef kCameraInfo kLc500xInfo;
typedef kCameraInfo kLc900xInfo;
typedef kCameraInfo kRc940Info;

typedef kCameraExt kCameraDynExp; 
typedef kCameraExt kCameraDynFpn; 
typedef kCameraExt kCameraOverride;
typedef kCameraExt kCameraSteps;
typedef kCameraExt kCameraPhaseDecoder;
typedef kCameraExt kCameraTracking; 

typedef kHealth kHostHealth;

typedef kInvertAlg kInvertCuda;
typedef kInvertAlg kInvertHost;

typedef kHxNode kHxNullNode;

typedef kLightExt kLightSteps; 
typedef kLightExt kLightOverride;

typedef kMsgSet kAlgMsg;
typedef kMsgSet kProfileMsg;
typedef kAlgMsg kBinCSumMsg;

typedef kProjectorInfo kDp01Info;
typedef kProjectorInfo kDp03Info;
typedef kProjectorInfo kLp01Info;

typedef kProjectorExt kProjectorAutoInt;
typedef kProjectorExt kProjectorSteps; 

typedef kPxBlock kBinCSum4Block;
typedef kPxBlock kForwardBlock;
typedef kPxBlock kInvertBlock;
typedef kPxBlock kLc250xFpnBlock;
typedef kPxBlock kMemoryDomainBlock;
typedef kPxBlock kMemoryTrafficBlock;
typedef kPxBlock kPxIoBlock; 
typedef kPxBlock kTimerBlock; 

typedef kPxPipe kPxParallelPipe; 
typedef kPxPipe kPxReplayPipe; 
typedef kPxPipe kPxSerialPipe;

typedef kSvDataOutChannel kSvDataOutApp;
typedef kSvDataOutChannel kSvDataOutNet;

typedef kSvHealthOutChannel kSvHealthOutApp;
typedef kSvHealthOutChannel kSvHealthOutNet;

typedef kStream kStorageStream; 
typedef kStream kZstdStream;

#endif
