/** 
 * @file    kFsUtils.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_UTILS_X_H
#define K_FIRESYNC_UTILS_X_H

#include <kFireSync/kNodeDef.h>

#define kPL_BIT_HEADER_SIZE                 (13)
#define kPL_BIT_KEY_DESIGN_NAME             (0x61)
#define kPL_BIT_KEY_TARGET_NAME             (0x62)
#define kPL_BIT_KEY_START                   (0xFF)

#define kPL_BIT_LP01_DESIGN_NAME            "lp01_chip.ncd"
#define kPL_BIT_LP01_TARGET_NAME            "6slx16csg225"

#define kPL_BIT_LP01_12V_DESIGN_NAME        "lp01_chip.ncd"
#define kPL_BIT_LP01_12V_TARGET_NAME        "6slx9csg225"

#define kPL_BIT_DP01_DESIGN_NAME            "dp01_chip.ncd"
#define kPL_BIT_DP01_TARGET_NAME            "6slx16csg225"

#define kPL_BIT_DP03_DESIGN_NAME            "dp03_chip.ncd"
#define kPL_BIT_DP03_TARGET_NAME            "6slx16csg225"

#define kFS_UTILS_HARDWARE_DIRNAME          "pl"
#define kFS_UTILS_PS_C64_DIRNAME            "c64x"
#define kFS_UTILS_PS_C64_DEB_DIRNAME        "c64xd"
#define kFS_UTILS_PS_ARM7_DIRNAME           "arm7"
#define kFS_UTILS_PS_ARM7_DEB_DIRNAME       "arm7d"
         
kFsFx(k64u) kMinimumEventPeriod(k64u moduleModulePeriod, kSize toleranceMultiplier);

kFsFx(kStatus) kInfo64uNsToUs(kInfo64u* info); 

kFsFx(kStatus) kRemoveArrayListObjects(kArrayList list, kArrayList remove); 
kFsFx(kStatus) kRemoveDuplicatesArrayListValues(kArrayList list); 
kFsFx(kStatus) kFindFirstArrayListObject(kArrayList list, kObject object, kSize* index); 
kFsFx(kStatus) kRemoveArrayListObjects(kArrayList list, kArrayList remove); 

kFsFx(kStatus) kAppendMessage(kArrayList list, const kChar* format, ...); 
kFsFx(kStatus) kIpConfig_Verify(const kIpConfig* ipConfig, const kChar* source, kArrayList list); 
kFsFx(kStatus) kIpConfig_Validate(const kIpConfig* ipConfig); 

kFsFx(kStatus) kPlBitVerifyBitData(kDaughterboardModel model, kByte* bitData, kSize bitSize);
kFsFx(kStatus) kPlBitVerifyHeader(const kByte* bitData, kSize bitSize);
kFsFx(kStatus) kPlBitSearchKey(const kByte* bitData, kSize bitSize, kByte searchKey, kChar* name, kSize capacity);
kFsFx(kStatus) kPlBitParseDesignName(const kByte* bitData, kSize bitSize, kChar* name, kSize capacity);
kFsFx(kStatus) kPlBitParseTargetName(const kByte* bitData, kSize bitSize, kChar* name, kSize capacity);

kFsFx(kStatus) kWriteBytes(kByte** it, kByte* end, void* data, kSize count);
kFsFx(kStatus) kWrite8u(kByte** it, kByte* end, k8u value);
kFsFx(kStatus) kWrite16u(kByte** it, kByte* end, kEndianness endianness, k16u value);
kFsFx(kStatus) kWrite32u(kByte** it, kByte* end, kEndianness endianness, k32u value);
kFsFx(kStatus) kWrite64u(kByte** it, kByte* end, kEndianness endianness, k64u value);

kFsFx(kStatus) kReadBytes(kByte** it, kByte* end, void* data, kSize count);
kFsFx(kStatus) kRead8u(kByte** it, kByte* end, k8u* value);
kFsFx(kStatus) kRead16u(kByte** it, kByte* end, kEndianness endianness, k16u* value);
kFsFx(kStatus) kRead32u(kByte** it, kByte* end, kEndianness endianness, k32u* value);
kFsFx(kStatus) kRead64u(kByte** it, kByte* end, kEndianness endianness, k64u* value);

kFsFx(kStatus) kAddMissingHardwarePath(kChar* path, kSize capacity);

kFsFx(kStatus) kFsUtils_FirmwarePath(kControllerType type, kBool isDebug, const kChar* fileName, kChar* filePath, kSize capacity);

kFsFx(kStatus) kParsePlConfig(kXml xml, kXmlItem item, k32u* configuration, kChar* path, kSize capacity, kVersion* version);

kFsFx(kStatus) kParsePlFilename(kString name, k32u* configuration, kVersion* version, kDaughterboardModel* model);

kFsFx(kStatus) kFsUtils_FindPsProgramByDescription(const kChar* programDescription, kControllerType type, kBool isDebug, kChar* path, kSize capacity);

kFsFx(kStatus) kFormatSensorMacAddress(k32u nodeId, kMacAddress* address);

kFsFx(kStatus) xkFormatLogOption(kLogOption options, kChar* buffer, kSize capacity);
kFsFx(kStatus) xkFormatLogMessage(kLogItem* item, kChar* buffer, kSize bufferSize);
kFsFx(kStatus) xkFormatLogMessageEx(kLogItem* item, kChar* buffer, kSize bufferSize);
kFsFx(kStatus) xkFormatLogBuffer(kLogItem* item, kChar* buffer, kSize bufferSize);

kFsFx(const kChar*) xkPlot_Title_NonInline(kPlot plot);
kFsFx(kSize) xkPlot_Count_NonInline(kPlot plot);
kFsFx(k32f) xkPlot_Height_NonInline(kPlot plot);
kFsFx(kObject) xkPlot_DataAt_NonInline(kPlot plot, kSize index);
kFsFx(const kChar*) xkPlot_NameAt_NonInline(kPlot plot, kSize index);

kInlineFx(void) kSwapRef(kPointer* a, kPointer* b)
{
    kPointer temp = *a;
    *a = *b; 
    *b = temp;  
}

kInlineFx(void) kTransferRef(kPointer* dest, kPointer* src)
{
    *dest = *src; 
    *src = kNULL;
}
 
kInlineFx(kStatus) kTransferDestroyRef(kObject* dest, kObject* src)
{
    kSwapRef(dest, src);
   
    return kDestroyRef(src);
}


kInlineFx(kStatus) kTransferDisposeRef(kObject* dest, kObject* src)
{
    kSwapRef(dest, src);
    
    return kDisposeRef(src);
}

kFsFx(kStatus) kFormatAffinity(kBitArray affinity, kString str);

kFsFx(kStatus) kParseAffinity(kBitArray affinity, kString str);


#endif
