/** 
 * @file    kUpgRuleSet.h
 * @brief   Declares the kUpgRuleSet class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kFS_UPG_RULE_SET_H
#define kFS_UPG_RULE_SET_H

#include <kFireSync/kFsDef.h>
#include <kFireSync/Upgrade/kUpgCondition.h>

/**
 * Contains a set of validation criteria.
 *
 * @class       kUpgRuleSet
 * @extends     kObject
 * @ingroup     kFireSync-Upgrade
 */
typedef kObject kUpgRuleSet;

/** @cond */
kDeclareClassEx(kFs, kUpgRuleSet, kObject)
/** @endcond */

kFsFx(kStatus) kUpgRuleSet_Construct(kUpgRuleSet* set, kAlloc alloc);

kFsFx(kStatus) kUpgRuleSet_Read(kUpgRuleSet set, kXml xml);
kFsFx(kStatus) kUpgRuleSet_Write(kUpgRuleSet set, kXml xml);

kFsFx(kStatus) kUpgRuleSet_SetName(kUpgRuleSet set, const kChar* name);
kFsFx(const kChar*) kUpgRuleSet_Name(kUpgRuleSet set);

kFsFx(kStatus) kUpgRuleSet_Add(kUpgRuleSet set, kUpgCondition* rule);
kFsFx(kStatus) kUpgRuleSet_Delete(kUpgRuleSet set, kSize index);
kFsFx(kStatus) kUpgRuleSet_Clear(kUpgRuleSet set);

kFsFx(kSize) kUpgRuleSet_Count(kUpgRuleSet set);
kFsFx(kUpgCondition) kUpgRuleSet_At(kUpgRuleSet set, kSize index);

#endif
