/** 
 * @file    kSvDataOutChannel.h
 * @brief   Declares the kSvDataOutChannel class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DATA_OUT_CHANNEL_H
#define K_FIRESYC_SERVER_DATA_OUT_CHANNEL_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class   kSvDataOutChannel
 * @extends kObject
 * @ingroup kFireSync-Server-Network
 * @brief   Abstract base class representing the server side of a data connection.
 */
//typedef kObject kSvDataOutChannel;      --forward-declared in kFsDef.x.h

kFsFx(kStatus) kSvDataOutChannel_Send(kSvDataOutChannel channel, kMsgInfo message);

kFsFx(kStatus) kSvDataOutChannel_SetMaxQueueSize(kSvDataOutChannel channel, kSize size);

kFsFx(kStatus) kSvDataOutChannel_SetMaxQueueCount(kSvDataOutChannel channel, kSize count);

kFsFx(kStatus) kSvDataOutChannel_SetThreadPriority(kSvDataOutChannel channel, kThreadPriorityClass priorityClass, k32s priorityOffset);

kFsFx(kStatus) kSvDataOutChannel_SetThreadAffinity(kSvDataOutChannel channel, kBitArray affinity);

kFsFx(kStatus) kSvDataOutChannel_EndSession(kSvDataOutChannel channel);

kFsFx(kStatus) kSvDataOutChannel_CheckActivity(kSvDataOutChannel channel);

kFsFx(kBool) kSvDataOutChannel_IsActive(kSvDataOutChannel channel);

#include <kFireSync/Server/Network/kSvDataOutChannel.x.h>

#endif
