/** 
 * @file    kSvControlChannel.h
 * @brief   Declares the kSvControlChannel class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_CONTROL_CHANNEL_H
#define K_FIRESYC_SERVER_CONTROL_CHANNEL_H

#include <kFireSync/Server/kSvDef.h>
#include <kApi/Io/kNetwork.h>

/**
 * @internal
 * @class   kSvControlChannel
 * @extends kObject
 * @ingroup kFireSync-Server-Network
 * @brief   Represents an FCP-6 server connection.
 */
//typedef kObject kSvControlChannel;      --forward-declared in kFsDef.x.h
 
/** 
 * Constructs a kSvControlChannel object.
 *
 * @public              @memberof kSvControlChannel
 * @param   channel     Destination for the constructed object handle. 
 * @param   node        Node to be controlled. 
 * @param   client      Client connection.
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvControlChannel_Construct(kSvControlChannel* channel, kSvNode node, kTcpClient client, kAlloc allocator);

kFsFx(kBool) kSvControlChannel_IsActive(kSvControlChannel channel);

#include <kFireSync/Server/Network/kSvControlChannel.x.h>

#endif
