/** 
 * @file    kSvControl.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_CONTROL_X_H
#define K_FIRESYC_SERVER_CONTROL_X_H

#define kSV_CONTROL_MAX_CONNECTIONS             (8)             ///Maximum simultaneous connnections.

#define kSV_CONTROL_QUIT_QUERY_PERIOD           (100000)        ///Polling interval for quit (stop) status (us). 

#define kSV_CONTROL_CLIENT_READ_BUFFER          (16384) 
#define kSV_CONTROL_SOCKET_READ_BUFFER          (-1) 
#define kSV_CONTROL_SOCKET_WRITE_BUFFER         (-1) 

typedef struct kSvControlClass
{
    kObjectClass base; 
    kSvNode node;                       ///Parent/owner.
    kIpEndPoint localEndPoint;          ///Local server IP endpoint.

    kThread serverThread;               ///Thread for accepting new connections.
    kTcpServer server;                  ///TCP server to accept new connections.

    kList connections;                  ///List of connections -- kList<kSvControlChannel>.

    kAtomic32s shouldQuit;              ///Is the server stopping?

} kSvControlClass; 

kDeclareClassEx(kFs, kSvControl, kObject)
        
kFsFx(kStatus) kSvControl_Init(kSvControl control, kType type, kSvNode node, kAlloc alloc);
kFsFx(kStatus) kSvControl_VRelease(kSvControl control);

kFsFx(kSvNode) kSvControl_Node(kSvControl control); 

kFsFx(kStatus) kSvControl_ServerThreadEntry(kSvControl control); 

kFsFx(kStatus) kSvControl_AddChannel(kSvControl control, kTcpClient client);
kFsFx(kStatus) kSvControl_RemoveChannel(kSvControl control); 
kFsFx(kStatus) kSvControl_RemoveInactiveChannels(kSvControl control); 

#endif
