/** 
 * @file    kHealth.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HEALTH_X_H
#define K_FIRESYNC_HEALTH_X_H

typedef struct kHealthStatic
{
    kHealth defaultProvider;        //Default health provider constructed automatically by this library (or kNULL, if none).
    kHealth provider;               //Global health provider (or kNULL, if none). 
} kHealthStatic; 

typedef struct kHealthVTable
{
    kObjectVTable base; 
} kHealthVTable; 

typedef struct kHealthClass
{
    kObjectClass base; 

    kType healthProbeType;              //Data type for health probes. 
    kType profileProbeType;             //Data type for profile probes. 
    
    kMap healthProbes;                  //Registered health probes.
    kMap profileProbes;                 //Registered profile probes.
    kEvent updateEvent;                 //Update listeners.
    kLock lock;                         //Provides exclusive access.
    kObject probeLock;                  //Lock for health/profile probes. 

    kHealthLog log;                     //Optional health log. 
} kHealthClass; 

kDeclareFullClassEx(kFs, kHealth, kObject)

kFsFx(kStatus) xkHealth_InitStatic(); 
kFsFx(kStatus) xkHealth_ReleaseStatic(); 

kFsFx(kStatus) kHealth_SetProvider(kHealth provider); 
kFsFx(kHealth) kHealth_Provider(); 

kFsFx(kStatus) kHealth_Init(kHealth health, kType type, kAlloc alloc); 
kFsFx(kStatus) kHealth_VRelease(kHealth health); 

kFsFx(kStatus) kHealth_AddHealthProbe(kHealth health, kHealthProbe probe); 
kFsFx(kStatus) kHealth_RemoveHealthProbe(kHealth health, kHealthProbe probe); 

kFsFx(kStatus) kHealth_AddProfileProbe(kHealth health, kProfileProbe probe); 
kFsFx(kStatus) kHealth_RemoveProfileProbe(kHealth health, kProfileProbe probe); 

kFsFx(kStatus) xkHealth_HealthStats(kHealth health, kArrayList stats, kHealthOption options);

kFsFx(kStatus) xkHealth_InitializeHealthProbeValue(kHealth health, kHealthProbe probe);
kFsFx(kStatus) xkHealth_FinalizeHealthProbeValue(kHealth health, kHealthProbe probe); 

kFsFx(kObject) kHealth_ProbeLock(kHealth health); 
kFsFx(kType) kHealth_HealthProbeType(kHealth health); 
kFsFx(kType) kHealth_ProfileProbeType(kHealth health); 

#endif














