/** 
 * @file    kHxLightState.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_LIGHT_STATE_X_H
#define K_FIRESYNC_HX_LIGHT_STATE_X_H

typedef struct kHxLightStateVTable
{
    kObjectVTable base;
} kHxLightStateVTable;

typedef struct kHxLightStateClass
{
    kObjectClass base; 

    /* 
     * Read-only attributes established during init.
     */

    kHxLight light;                 //Parent.
    kSize id;                       //Index of object in context of parent.

    /* 
     * Dynamic properties that are automatically initialized during init. 
     */

    k64u delay;                     //Nominal delay setting (FS ns). 
    k64u exposure;                  //Nominal exposure setting (FS ns). 
    k64u gap;                       //Nominal gap setting (FS ns).
    k64u leadIn;                    //Invididual lead-in (FS ns).
    k64u leadOut;                   //Individual lead-out (FS ns).
    k64u totalLeadIn;               //Total lead-in across synchronized modules (FS ns).
    k64u totalLeadOut;              //Total lead-out across synchronized modules (FS ns).

} kHxLightStateClass; 

kDeclareVirtualClassEx(kFs, kHxLightState, kObject)

kFsFx(kStatus) xkHxLightState_Init(kHxLightState state, kType type, kHxLight light, kSize id, kAlloc alloc); 

kFsFx(kStatus) xkHxLightState_VRelease(kHxLightState state); 

#endif
