/** 
 * @file    kHxLightState.h
 * @brief   Declares the kHxLightState class.
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_LIGHT_STATE_H
#define K_FIRESYNC_HX_LIGHT_STATE_H

#include <kFireSync/kNodeDef.h>
#include <kFireSync/Hardware/kHxLightState.x.h>

/**
 * @class       kHxLightState
 * @extends     kObject
 * @ingroup     kFireSync-Hardware
 * @internal
 * @brief       Abstract base class for hardware light-state classes.
 */
//typedef kObject kHxLight;      --forward-declared in kFsDef.x.h

kInlineFx(kStatus) kHxLightState_SetDelay(kHxLightState state, k64u delay)
{
    kObj(kHxLightState, state);

    obj->delay = delay; 

    return kOK; 
}

kInlineFx(k64u) kHxLightState_Delay(kHxLightState state)
{
    kObj(kHxLightState, state);

    return obj->delay;
}

kInlineFx(kStatus) kHxLightState_SetExposure(kHxLightState state, k64u exposure)
{
    kObj(kHxLightState, state);

    obj->exposure = exposure; 

    return kOK; 
}

kInlineFx(k64u) kHxLightState_Exposure(kHxLightState state)
{
    kObj(kHxLightState, state);

    return obj->exposure; 
}

kInlineFx(kStatus) kHxLightState_SetGap(kHxLightState state, k64u gap)
{
    kObj(kHxLightState, state);

    obj->gap = gap; 

    return kOK; 
}

kInlineFx(k64u) kHxLightState_Gap(kHxLightState state)
{
    kObj(kHxLightState, state);

    return obj->gap;
}

kInlineFx(kStatus) kHxLightState_SetLeadIn(kHxLightState state, k64u leadIn)
{
    kObj(kHxLightState, state);

    obj->leadIn = leadIn; 

    return kOK; 
}

kInlineFx(k64u) kHxLightState_LeadIn(kHxLightState state)
{
    kObj(kHxLightState, state);

    return obj->leadIn;
}

kInlineFx(kStatus) kHxLightState_SetTotalLeadIn(kHxLightState state, k64u totalLeadIn)
{
    kObj(kHxLightState, state);

    obj->totalLeadIn = totalLeadIn; 

    return kOK; 
}

kInlineFx(k64u) kHxLightState_TotalLeadIn(kHxLightState state)
{
    kObj(kHxLightState, state);

    return obj->totalLeadIn;
}

kInlineFx(kStatus) kHxLightState_SetLeadOut(kHxLightState state, k64u leadOut)
{
    kObj(kHxLightState, state);

    obj->leadOut = leadOut; 

    return kOK; 
}

kInlineFx(k64u) kHxLightState_LeadOut(kHxLightState state)
{
    kObj(kHxLightState, state);

    return obj->leadOut;
}

kInlineFx(kStatus) kHxLightState_SetTotalLeadOut(kHxLightState state, k64u totalLeadOut)
{
    kObj(kHxLightState, state);

    obj->totalLeadOut = totalLeadOut; 

    return kOK; 
}

kInlineFx(k64u) kHxLightState_TotalLeadOut(kHxLightState state)
{
    kObj(kHxLightState, state);

    return obj->totalLeadOut;
}

#endif
