/** 
 * @file    kHxGpio.h
 * @brief   Declares the kHxGpio class.
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_GPIO_H
#define K_FIRESYNC_HX_GPIO_H

#include <kFireSync/kNodeDef.h>

typedef struct kHxGpioPin
{
    kSize pinIndex;
    kGpioPin pinType;
    kBool eventsEnabled;
} kHxGpioPin;

#include <kFireSync/Hardware/kHxGpio.x.h>

/**
 * @class       kHxGpio
 * @extends     kObject
 * @ingroup     kFireSync-Hardware
 * @internal
 * @brief       Abstract base class for hardware GPIO classes.
 */
//typedef kObject kHxGpio;      --forward-declared in kFsDef.x.h

kInlineFx(kHxNode) kHxGpio_Node(kHxGpio gpio)
{
    kObj(kHxGpio, gpio); 

    return obj->node;
}

kInlineFx(kStatus) kHxGpio_SetEventHandler(kHxGpio gpio, kCallbackFx function, kPointer receiver, kAlloc eventAlloc)
{
    return xkHxGpio_VTable(gpio)->VSetEventHandler(gpio, function, receiver, eventAlloc);
}

kInlineFx(kSize) kHxGpio_BankCount(kHxGpio gpio)
{
    return xkHxGpio_VTable(gpio)->VBankCount(gpio);
}

kInlineFx(kGpioBankType) kHxGpio_BankType(kHxGpio gpio, kSize bankIndex)
{
    return xkHxGpio_VTable(gpio)->VBankType(gpio, bankIndex);
}

kInlineFx(kSize) kHxGpio_PinCount(kHxGpio gpio, kSize bankIndex)
{
    return xkHxGpio_VTable(gpio)->VPinCount(gpio, bankIndex);
}

kInlineFx(kStatus) kHxGpio_EnableEvents(kHxGpio gpio, kSize bankIndex, kSize pinIndex, kBool enabled)
{
    return xkHxGpio_VTable(gpio)->VEnableEvents(gpio, bankIndex, pinIndex, enabled);
}

kInlineFx(kBool) kHxGpio_EventsEnabled(kHxGpio gpio, kSize bankIndex, kSize pinIndex)
{
    return xkHxGpio_VTable(gpio)->VEventsEnabled(gpio, bankIndex, pinIndex);
}

kInlineFx(kStatus) kHxGpio_SetState(kHxGpio gpio, kSize bankIndex, k64u mask, k64u state)
{
    return xkHxGpio_VTable(gpio)->VSetState(gpio, bankIndex, mask, state);
}

kInlineFx(kStatus) kHxGpio_GetState(kHxGpio gpio, kSize bankIndex, k64u* state)
{
    return xkHxGpio_VTable(gpio)->VGetState(gpio, bankIndex, state);
}

kInlineFx(kStatus) kHxGpio_SetPinConfig(kHxGpio gpio, kSize bankIndex, kArrayList pinConfig)
{
    return xkHxGpio_VTable(gpio)->VSetPinConfig(gpio, bankIndex, pinConfig);
}

kInlineFx(kStatus) kHxGpio_GetPinConfig(kHxGpio gpio, kSize bankIndex, kArrayList pinConfig)
{
    return xkHxGpio_VTable(gpio)->VGetPinConfig(gpio, bankIndex, pinConfig);
}

#endif
