/** 
 * @file    kMsgSet.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_MSG_SET_X_H
#define K_FIRESYNC_MSG_SET_X_H

#include <kApi/Data/kXml.h>

typedef struct kMsgSetClass
{
    kObjectClass base; 
} kMsgSetClass; 

typedef struct kMsgSetVTable
{
    kObjectVTable base; 
    kSize (kCall* VCount)(kMsgSet set); 
    const kStamp* (kCall* VStampAt)(kMsgSet set, kSize index); 
    kStatus (kCall* VSetStampAt)(kMsgSet set, kSize index, const kStamp* stamp); 
    kStatus (kCall* VDataAt)(kMsgSet set, kSize index, kArrayList* list); 
} kMsgSetVTable; 

kDeclareVirtualClassEx(kFs, kMsgSet, kObject)

kInlineFx(kStatus) kMsgSet_Init(kMsgSet set, kType type, kAlloc alloc)
{
    return kObject_Init(set, type, alloc); 
}

kInlineFx(kStatus) kMsgSet_VRelease(kMsgSet set)
{
    return kObject_VRelease(set);
}

kInlineFx(kSize) kMsgSet_VCount(kMsgSet set)
{
    return 0; 
}

kInlineFx(const kStamp*) kMsgSet_VStampAt(kMsgSet set, kSize index)
{
    return kNULL; 
}

kInlineFx(kStatus) kMsgSet_VSetStampAt(kMsgSet set, kSize index, const kStamp* stamp)
{
    return kERROR_UNIMPLEMENTED; 
}

kInlineFx(kStatus) kMsgSet_VDataAt(kMsgSet set, kSize index, kArrayList* list)
{
    return kERROR_UNIMPLEMENTED; 
}

#endif
