/** 
 * @file    kDataTreeItem.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DATA_TREE_ITEM_X_H
#define K_FIRESYNC_DATA_TREE_ITEM_X_H

#include <kFireSync/Data/kDataTree.h>
#include <kApi/Data/kString.h>
#include <kApi/Io/kSerializer.h>

#define kDATA_TREE_ITEM_DEFAULT_TEXT_SIZE          (64)

typedef struct kDataTreeItemName 
{
    kChar text[kDATA_TREE_ITEM_DEFAULT_TEXT_SIZE];
    kChar* buffer;
    kSize capacity;
} kDataTreeItemName;

typedef struct kDataTreeItemClass 
{
    kObjectClass base; 
    kDataTreeItemName name;
    kObject value;
    kDataTreeItem parent; 
    kDataTreeItem firstChild; 
    kDataTreeItem previousSibling; 
    kDataTreeItem nextSibling; 
} kDataTreeItemClass;

kDeclareClassEx(kFs, kDataTreeItem, kObject)

kFsFx(kStatus) xkDataTreeItem_ConstructFramework(kDataTreeItem* item, kAlloc allocator); 

kFsFx(kStatus) kDataTreeItem_Construct(kDataTreeItem* item, const kChar* name, kObject allocator);
kFsFx(kStatus) kDataTreeItem_Init(kDataTreeItem item, kType classType, const kChar* name, kAlloc allocator);
kFsFx(kStatus) kDataTreeItem_VRelease(kDataTreeItem item);
kFsFx(kStatus) kDataTreeItem_VClone(kDataTreeItem item, kDataTreeItem source, kAlloc valueAlloc, kObject context);
kFsFx(kBool) kDataTreeItem_VHasShared(kDataTreeItem item); 
kFsFx(kSize) kDataTreeItem_VSize(kDataTreeItem item);
kFsFx(kAllocTrait) kDataTreeItem_VAllocTraits(kDataTreeItem item);

kFsFx(kStatus) xkDataTreeItem_WriteDat5V0(kDataTreeItem item, kSerializer serializer);
kFsFx(kStatus) xkDataTreeItem_ReadDat5V0(kDataTreeItem item, kSerializer serializer);
kFsFx(kStatus) xkDataTreeItem_WriteDat6V0(kDataTreeItem item, kSerializer serializer);
kFsFx(kStatus) xkDataTreeItem_ReadDat6V0(kDataTreeItem item, kSerializer serializer);

kFsFx(kStatus) kDataTreeItem_SetValue(kDataTreeItem item, kType type, const void* value); 
kFsFx(kStatus) kDataTreeItem_SetText(kDataTreeItem item, const kChar* value); 
kFsFx(kStatus) kDataTreeItem_SetData(kDataTreeItem item, kObject value, kBool clone); 

kFsFx(kStatus) kDataTreeItem_Value(kDataTreeItem item, kType type, void* value); 
kFsFx(kStatus) kDataTreeItem_Text(kDataTreeItem item, kChar* value, k32u capacity); 
kFsFx(kStatus) kDataTreeItem_Data(kDataTreeItem item, kObject* value, kAlloc allocator); 
kFsFx(kStatus) kDataTreeItem_Child(kDataTreeItem item, const kChar* childName, kDataTreeItem* child);

kFsFx(kStatus) kDataTreeItem_Insert(kDataTreeItem item, kDataTreeItem before, kDataTreeItem child);
kFsFx(kStatus) kDataTreeItem_Remove(kDataTreeItem item);

kFsFx(kDataTreeItem) kDataTreeItem_Parent(kDataTreeItem item); 
kFsFx(kDataTreeItem) kDataTreeItem_FirstChild(kDataTreeItem item); 
kFsFx(kDataTreeItem) kDataTreeItem_LastChild(kDataTreeItem item); 
kFsFx(kDataTreeItem) kDataTreeItem_PreviousSibling(kDataTreeItem item);
kFsFx(kDataTreeItem) kDataTreeItem_NextSibling(kDataTreeItem item); 

kFsFx(kObject) kDataTreeItem_GetData(kDataTreeItem item); 

kFsFx(kStatus) kDataTreeItem_Reserve(kDataTreeItem item, kSize size);
kFsFx(kStatus) kDataTreeItem_SetName(kDataTreeItem item, const kChar* str);

kInlineFx(kChar*) kDataTreeItem_Name(kDataTreeItem item)
{
    kObjR(kDataTreeItem, item); 

    return kIsNull(obj->name.buffer) ? obj->name.text : obj->name.buffer; 
}

#endif
